<?php

/**
 * Adds the thread status tables.
 *
 * @author Joshua Ruesweg
 * @copyright 2001-2021 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum
 */

use wcf\system\database\table\column\NotNullInt10DatabaseTableColumn;
use wcf\system\database\table\column\NotNullVarchar255DatabaseTableColumn;
use wcf\system\database\table\DatabaseTable;
use wcf\system\database\table\index\DatabaseTableForeignKey;
use wcf\system\database\table\index\DatabaseTableIndex;
use wcf\system\database\table\index\DatabaseTablePrimaryIndex;

return [
    DatabaseTable::create('wbb1_thread_user_status')
        ->columns([
            NotNullInt10DatabaseTableColumn::create('userID'),
            NotNullInt10DatabaseTableColumn::create('threadID'),
            NotNullVarchar255DatabaseTableColumn::create('status'),
        ])
        ->foreignKeys([
            DatabaseTableForeignKey::create()
                ->columns(['userID'])
                ->referencedTable('wcf1_user')
                ->referencedColumns(['userID'])
                ->onDelete('CASCADE'),
            DatabaseTableForeignKey::create()
                ->columns(['threadID'])
                ->referencedTable('wbb1_thread')
                ->referencedColumns(['threadID'])
                ->onDelete('CASCADE'),
        ])
        ->indices([
            DatabaseTablePrimaryIndex::create()
                ->columns(['userID', 'threadID']),
            DatabaseTableIndex::create('userID_status')
                ->columns(['userID', 'status']),
        ]),
    DatabaseTable::create('wbb1_board_user_status')
        ->columns([
            NotNullInt10DatabaseTableColumn::create('userID'),
            NotNullInt10DatabaseTableColumn::create('boardID'),
            NotNullVarchar255DatabaseTableColumn::create('status'),
        ])
        ->foreignKeys([
            DatabaseTableForeignKey::create()
                ->columns(['userID'])
                ->referencedTable('wcf1_user')
                ->referencedColumns(['userID'])
                ->onDelete('CASCADE'),
            DatabaseTableForeignKey::create()
                ->columns(['boardID'])
                ->referencedTable('wbb1_board')
                ->referencedColumns(['boardID'])
                ->onDelete('CASCADE'),
        ])
        ->indices([
            DatabaseTablePrimaryIndex::create()
                ->columns(['userID', 'boardID']),
            DatabaseTableIndex::create('userID_status')
                ->columns(['userID', 'status']),
        ]),
];
