<?php

namespace wbb\data\board;

use wcf\system\WCF;

/**
 * Represents a restricted board node list.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\Data\Board
 */
class RestrictedBoardNodeList extends BoardNodeList
{
    /**
     * @inheritDoc
     */
    protected function isVisible(Board $board)
    {
        return $board->getPermission() && !$board->isInvisible && (!$board->isPrivate || WCF::getUser()->userID);
    }
}
