<?php

namespace wbb\system\cronjob;

use wbb\data\post\PostAction;
use wcf\data\cronjob\Cronjob;
use wcf\system\cronjob\AbstractCronjob;
use wcf\system\WCF;

/**
 * Delete thrashed posts and threads.
 *
 * Threads are automatically deleted if all of its posts are deleted.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Cronjob
 */
class EmptyRecycleBinCronjob extends AbstractCronjob
{
    /**
     * @inheritDoc
     */
    public function execute(Cronjob $cronjob)
    {
        parent::execute($cronjob);

        if (WBB_THREAD_EMPTY_RECYCLE_BIN_CYCLE) {
            $sql = "SELECT  postID
                    FROM    wbb" . WCF_N . "_post
                    WHERE   isDeleted = ?
                        AND deleteTime < ?";
            $statement = WCF::getDB()->prepareStatement($sql, 1000);
            $statement->execute([1, TIME_NOW - WBB_THREAD_EMPTY_RECYCLE_BIN_CYCLE * 86400]);
            $postIDs = $statement->fetchAll(\PDO::FETCH_COLUMN);

            if (!empty($postIDs)) {
                $action = new PostAction($postIDs, 'delete');
                $action->executeAction();
            }
        }
    }
}
