<?php

namespace wbb\system\moderation;

use wbb\data\thread\DeletedThreadList;
use wcf\system\moderation\AbstractDeletedContentProvider;

/**
 * Implementation of IDeletedContentProvider for deleted threads.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Moderation
 */
class DeletedThreadProvider extends AbstractDeletedContentProvider
{
    /**
     * @inheritDoc
     */
    public function getObjectList()
    {
        $threadList = new DeletedThreadList();
        $threadList->sqlOrderBy = "thread.deleteTime DESC, thread.threadID DESC";

        return $threadList;
    }

    /**
     * @inheritDoc
     */
    public function getTemplateName()
    {
        return 'deletedThreadList';
    }
}
