{assign var='hasWatchedBoards' value=$boardNodeList->valid()}

{capture assign='contentInteractionButtons'}
	{if $hasWatchedBoards}
		<a href="#" id="stopWatchingButton" class="contentInteractionButton jsOnly button small"><span class="icon icon16 fa-times"></span> <span>{lang}wbb.board.watchedBoards.stopWatchingAll{/lang}</span></a>
		<a href="#" id="markAllWatchedBoards" class="contentInteractionButton jsOnly button small"><span class="icon icon16 fa-check-square-o"></span> <span>{lang}wbb.board.watchedBoards.markAll{/lang}</span></a>
	{/if}
{/capture}

{include file='header'}

{if $hasWatchedBoards}
	<div class="section">
		<ul class="wbbBoardList">
			{include file='boardNodeList' application='wbb' disableAds=true disableBoardNodeUsersOnline=true}
		</ul>
	</div>
{else}
	<p class="info" role="status">{lang}wcf.global.noItems{/lang}</p>
{/if}

<footer class="contentFooter">
	{hascontent}
		<nav class="contentFooterNavigation">
			<ul>
				{content}
					{event name='contentFooterNavigation'}
				{/content}
			</ul>
		</nav>
	{/hascontent}
</footer>

{if $hasWatchedBoards}
	<script data-relocate="true">
		require([
			'Language',
			'WoltLabSuite/Forum/Controller/Board/WatchedList',
			'WoltLabSuite/Forum/Ui/Board/MarkAsRead',
		], (
			Language,
			ControllerBoardWatchedList,
			BoardMarkAsRead,
		) => {
			Language.addObject({
				'wcf.user.objectWatch.manageSubscription': '{jslang}wcf.user.objectWatch.manageSubscription{/jslang}',
				'wbb.board.watchedBoards.markAll': '{jslang}wbb.board.watchedBoards.markAll{/jslang}',
				'wbb.board.watchedBoards.unmarkAll': '{jslang}wbb.board.watchedBoards.unmarkAll{/jslang}',
				'wbb.board.watchedBoards.stopWatchingAll': '{jslang}wbb.board.watchedBoards.stopWatchingAll{/jslang}',
				'wbb.board.watchedBoards.stopWatchingAll.confirmMessage': '{jslang}wbb.board.watchedBoards.stopWatchingAll.confirmMessage{/jslang}',
				'wbb.board.watchedBoards.stopWatchingMarked': '{jslang __literal=true}wbb.board.watchedBoards.stopWatchingMarked{/jslang}',
				'wbb.board.watchedBoards.stopWatchingMarked.confirmMessage': '{jslang}wbb.board.watchedBoards.stopWatchingMarked.confirmMessage{/jslang}'
			});
			
			ControllerBoardWatchedList.setup();
			
			BoardMarkAsRead.setup();
		});
	</script>
{/if}

{include file='footer'}
