<?php

namespace wbb\data\post;

use wcf\data\object\type\AbstractObjectTypeProvider;

/**
 * Object type provider implementation for posts.
 *
 * @author  Matthias Schmidt
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\Data\Post
 *
 * @method  Post        getObjectByID($objectID)
 * @method  Post[]      getObjectsByIDs(array $objectIDs)
 */
class PostProvider extends AbstractObjectTypeProvider
{
    /**
     * @inheritDoc
     */
    public $className = Post::class;

    /**
     * @inheritDoc
     */
    public $listClassName = PostList::class;
}
