<?php

namespace wbb\system\cache\builder;

use wcf\data\object\type\ObjectTypeCache;
use wcf\data\tag\Tag;
use wcf\data\tag\TagCloudTag;
use wcf\system\cache\builder\TagCloudCacheBuilder;
use wcf\system\database\util\PreparedStatementConditionBuilder;
use wcf\system\WCF;

/**
 * Caches tag cloud per board.
 *
 * @author  Alexander Ebert
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Cache\Builder
 */
class BoardTagCloudCacheBuilder extends TagCloudCacheBuilder
{
    /**
     * @inheritDoc
     */
    protected $maxLifetime = 3600;

    /**
     * @inheritDoc
     */
    protected function rebuild(array $parameters)
    {
        $objectType = ObjectTypeCache::getInstance()
            ->getObjectTypeByName('com.woltlab.wcf.tagging.taggableObject', 'com.woltlab.wbb.thread');

        $conditions = new PreparedStatementConditionBuilder();
        if (isset($parameters['languageIDs']) && !empty($parameters['languageIDs'])) {
            $conditions->add("tag.languageID IN (?)", [$parameters['languageIDs']]);
        }
        $conditions->add("tag_to_object.objectTypeID = ?", [$objectType->objectTypeID]);
        $conditions->add("thread.boardID = ?", [$parameters['boardID']]);

        $sql = "SELECT      tag.tagID, COUNT(*) AS counter
                FROM        wcf" . WCF_N . "_tag tag
                INNER JOIN  wcf" . WCF_N . "_tag_to_object tag_to_object
                ON          tag.tagID = tag_to_object.tagID
                INNER JOIN  wbb" . WCF_N . "_thread thread
                ON          thread.threadID = tag_to_object.objectID
                " . $conditions . "
                GROUP BY    tag.tagID
                ORDER BY    counter DESC";
        $statement = WCF::getDB()->prepareStatement($sql);
        $statement->execute($conditions->getParameters());
        $tagIDs = $statement->fetchMap('tagID', 'counter');

        if (!empty($tagIDs)) {
            $conditions = new PreparedStatementConditionBuilder();
            $conditions->add("tagID IN (?)", [\array_keys($tagIDs)]);

            $sql = "SELECT  *
                    FROM    wcf" . WCF_N . "_tag
                    " . $conditions;
            $statement = WCF::getDB()->prepareStatement($sql);
            $statement->execute($conditions->getParameters());
            while ($row = $statement->fetchArray()) {
                $row['counter'] = $tagIDs[$row['tagID']];
                $this->tags[\mb_strtolower($row['name'])] = new TagCloudTag(new Tag(null, $row));
            }

            // sort by counter
            \uasort($this->tags, ['self', 'compareTags']);
        }

        return $this->tags;
    }
}
