/**
 * Handles the mark all as read button for the forum.
 *
 * @author  Matthias Schmidt
 * @copyright  2001-2021 WoltLab GmbH
 * @license  WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module  WoltLabSuite/Forum/Ui/Board/MarkAllAsRead
 */
define(["require", "exports", "tslib", "WoltLabSuite/Core/Ajax", "WoltLabSuite/Core/Event/Handler", "WoltLabSuite/Core/Ui/Notification", "./MarkAsRead"], function (require, exports, tslib_1, Ajax, EventHandler, UiNotification, BoardMarkAsRead) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.BoardMarkAllAsRead = void 0;
    Ajax = tslib_1.__importStar(Ajax);
    EventHandler = tslib_1.__importStar(EventHandler);
    UiNotification = tslib_1.__importStar(UiNotification);
    BoardMarkAsRead = tslib_1.__importStar(BoardMarkAsRead);
    class BoardMarkAllAsRead {
        constructor(markAsReadButton, callback) {
            markAsReadButton.addEventListener("click", (ev) => this.click(ev));
            this.callback = callback;
        }
        _ajaxSetup() {
            return {
                data: {
                    actionName: "markAllAsRead",
                    className: "wbb\\data\\board\\BoardAction",
                },
            };
        }
        _ajaxSuccess() {
            if (this.callback) {
                this.callback();
            }
            document.querySelectorAll(".wbbThreadList, .wbbSidebarThreadList").forEach((threadList) => {
                threadList.querySelectorAll(".new").forEach((el) => el.classList.remove("new"));
            });
            document.querySelectorAll(".mainMenu .active .badge").forEach((el) => el.remove());
            const boardList = document.querySelector(".wbbBoardList");
            if (boardList) {
                boardList.querySelectorAll(".markAsRead").forEach((el) => {
                    BoardMarkAsRead.setAsRead(el);
                });
            }
            EventHandler.fire("com.woltlab.wcf.MainMenuMobile", "updateButtonState");
            UiNotification.show();
        }
        click(event) {
            event.preventDefault();
            Ajax.api(this);
        }
    }
    exports.BoardMarkAllAsRead = BoardMarkAllAsRead;
    exports.default = BoardMarkAllAsRead;
});
