<?php

namespace wbb\system\condition\post;

use wbb\data\post\Post;
use wcf\system\condition\AbstractObjectTextPropertyCondition;

/**
 * Condition implementation for the name of the user who created a post.
 *
 * @author  Matthias Schmidt
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Condition\Post
 * @since   5.0
 */
class PostUsernameCondition extends AbstractObjectTextPropertyCondition
{
    /**
     * @inheritDoc
     */
    protected $className = Post::class;

    /**
     * @inheritDoc
     */
    protected $description = 'wbb.post.condition.username.description';

    /**
     * @inheritDoc
     */
    protected $fieldName = 'wbbPostUsername';

    /**
     * @inheritDoc
     */
    protected $label = 'wbb.post.condition.username';

    /**
     * @inheritDoc
     */
    protected $propertyName = 'username';

    /**
     * @inheritDoc
     */
    protected $supportsMultipleValues = true;
}
