/**
 * Handles the mark as read button for individual threads.
 *
 * @author  Joshua Ruesweg, Marcel Werk
 * @copyright  2001-2022 WoltLab GmbH
 * @license  WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module  WoltLabSuite/Forum/Ui/Thread/MarkAsRead
 * @since 5.5
 */
define(["require", "exports", "WoltLabSuite/Core/Ajax"], function (require, exports, Ajax_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.setup = void 0;
    const unreadThreads = new WeakSet();
    async function markAsRead(thread) {
        var _a;
        const threadId = parseInt(thread.dataset.threadId, 10);
        await (0, Ajax_1.dboAction)("markAsRead", "wbb\\data\\thread\\ThreadAction").objectIds([threadId]).dispatch();
        thread.classList.remove("new");
        (_a = thread.querySelector(".columnAvatar p")) === null || _a === void 0 ? void 0 : _a.removeAttribute("title");
    }
    /**
     * Sets up the marking threads as read handler.
     */
    function setup() {
        document.querySelectorAll(".wbbThreadList .new .columnAvatar").forEach((el) => {
            if (!unreadThreads.has(el)) {
                unreadThreads.add(el);
                el.addEventListener("dblclick", (event) => {
                    event.preventDefault();
                    const thread = el.closest(".wbbThread");
                    if (!thread.classList.contains("new")) {
                        return;
                    }
                    void markAsRead(thread);
                }, { once: true });
            }
        });
    }
    exports.setup = setup;
});
