/**
 * Handles the thread watch button.
 *
 * @author  Joshua Ruesweg
 * @copyright  2001-2021 WoltLab GmbH
 * @license  WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module  WoltLabSuite/Forum/Controller/Thread/SubscriptionStatusHandler
 */
define(["require", "exports", "tslib", "WoltLabSuite/Core/Ajax", "WoltLabSuite/Core/Ui/Notification", "WoltLabSuite/Core/Language", "WoltLabSuite/Core/Event/Handler"], function (require, exports, tslib_1, Ajax, UiNotification, Language, EventHandler) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.SubscriptionStatusHandler = void 0;
    Ajax = tslib_1.__importStar(Ajax);
    UiNotification = tslib_1.__importStar(UiNotification);
    Language = tslib_1.__importStar(Language);
    EventHandler = tslib_1.__importStar(EventHandler);
    class SubscriptionStatusHandler {
        constructor() {
            this.dropdowns = new Map();
            document.querySelectorAll(".subscribeThreadStatusDropdown").forEach((element) => {
                if (!element.dataset.threadId) {
                    throw new Error("Missing threadID for '.subscribeThreadStatusDropdown' element.");
                }
                const threadId = parseInt(element.dataset.threadId, 10);
                if (!this.dropdowns.has(threadId)) {
                    this.dropdowns.set(threadId, new Set());
                }
                this.dropdowns.get(threadId).add(element);
                element.querySelectorAll(".subscribeThreadSelect").forEach((element) => {
                    if (!element.dataset.status) {
                        throw new Error("Missing 'data-status' attribute for '.subscribeThreadSelect' element.");
                    }
                    element.addEventListener("click", (event) => void this.click(event));
                });
            });
        }
        async click(event) {
            event.preventDefault();
            const target = event.target;
            const dropdown = target.closest(".subscribeThreadStatusDropdown");
            const li = target.closest(".subscribeThreadSelect");
            const status = li.dataset.status;
            const threadID = parseInt(dropdown.dataset.threadId, 10);
            const response = (await Ajax.dboAction("saveSubscriptionStatus", "wbb\\data\\thread\\ThreadStatusAction")
                .payload({
                threadID,
                status,
            })
                .dispatch());
            if (this.dropdowns.has(response.threadID)) {
                this.dropdowns.get(response.threadID).forEach((element) => {
                    var _a;
                    element.querySelectorAll(".subscribeThreadSelect").forEach((li) => {
                        li.classList.remove("active");
                    });
                    (_a = element.querySelector(`.subscribeThreadSelect[data-status="${response.status}"]`)) === null || _a === void 0 ? void 0 : _a.classList.add("active");
                });
            }
            document
                .querySelectorAll(`.subscribeThreadStatusDropdownToggle[data-thread-id="${response.threadID}"]`)
                .forEach((element) => {
                const icon = element.querySelector(".icon");
                const label = element.querySelector("span:not(.icon)");
                if (response.status !== "normal") {
                    element.classList.add("active");
                    icon.classList.remove("fa-bookmark", "fa-ban", "fa-bookmark-o");
                    icon.classList.add(response.status === "ignoring" ? "fa-ban" : "fa-bookmark");
                    label.textContent = Language.get(`wbb.thread.status.${response.status}`);
                }
                else {
                    element.classList.remove("active");
                    icon.classList.remove("fa-bookmark", "fa-ban");
                    icon.classList.add("fa-bookmark-o");
                    label.textContent = Language.get("wcf.user.objectWatch.button.subscribe");
                }
                element.dataset.isSubscribed = response.status === "watching" ? "1" : "0";
            });
            EventHandler.fire("com.woltlab.wcf.objectWatch", "updatedSubscription");
            UiNotification.show();
        }
    }
    exports.SubscriptionStatusHandler = SubscriptionStatusHandler;
    exports.default = SubscriptionStatusHandler;
});
