<?php

namespace wbb\system\event\listener;

use wbb\data\board\BoardCache;
use wbb\data\board\BoardNodeList;
use wcf\acp\form\AbstractCategoryEditForm;
use wcf\system\event\listener\IParameterizedEventListener;
use wcf\system\exception\UserInputException;
use wcf\system\WCF;

/**
 * Handles individual board selection for each article category.
 *
 * @author  Alexander Ebert, Matthias Schmidt
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Event\Listener
 */
class CategoryArticleThreadBoardListener implements IParameterizedEventListener
{
    /**
     * board id
     * @var int
     */
    protected $boardID = 0;

    /**
     * board node list
     * @var BoardNodeList
     */
    protected $boardNodeList;

    /**
     * @inheritDoc
     */
    public function execute($eventObj, $className, $eventName, array &$parameters)
    {
        if (WBB_ARTICLE_THREAD_SINGLE_BOARD) {
            return;
        }

        if ($this->boardNodeList === null) {
            $this->boardNodeList = new BoardNodeList();
            $this->boardNodeList->readNodeTree();
        }

        switch ($eventName) {
            case 'assignVariables':
                WCF::getTPL()->assign([
                    'articleThreadBoardNodeList' => $this->boardNodeList->getNodeList(),
                    'articleThreadBoardID' => $this->boardID,
                ]);
                break;

            case 'readData':
                if (empty($_POST) && $eventObj instanceof AbstractCategoryEditForm) {
                    $this->boardID = ($eventObj->category->articleThreadBoardID ?: 0);
                }
                break;

            case 'save':
                $eventObj->additionalData['articleThreadBoardID'] = $this->boardID;
                break;

            case 'validate':
                $this->boardID = (!empty($_POST['articleThreadBoardID'])) ? \intval($_POST['articleThreadBoardID']) : 0;
                if ($this->boardID) {
                    $board = BoardCache::getInstance()->getBoard($this->boardID);
                    if ($board === null || !$board->isBoard()) {
                        throw new UserInputException('articleThreadBoardID', 'invalid');
                    }
                }
                break;
        }
    }
}
