/**
 * Quote manager for forum posts.
 *
 * @author  Matthias Schmidt
 * @copyright 2001-2021 WoltLab GmbH
 * @license GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @module  WoltLabSuite/Forum/Ui/Post/Quote
 * @woltlabExcludeBundle tiny
 */
define(["require", "exports", "WoltLabSuite/Core/Ui/Message/Quote"], function (require, exports, Quote_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.UiPostQuote = void 0;
    class UiPostQuote extends Quote_1.UiMessageQuote {
        constructor(quoteManager) {
            super(quoteManager, "wbb\\data\\post\\PostAction", "com.woltlab.wbb.post", ".message", ".messageBody", ".messageBody > .messageText", true);
        }
    }
    exports.UiPostQuote = UiPostQuote;
    exports.default = UiPostQuote;
});
