<?php

namespace wbb\system\user\notification\object\type;

use wbb\system\user\notification\object\ThreadModerationUserNotificationObject;
use wcf\data\modification\log\ModificationLog;
use wcf\data\modification\log\ModificationLogList;
use wcf\system\user\notification\object\type\AbstractUserNotificationObjectType;

/**
 * Represents a modification log entry for threads as a notification object type.
 *
 * @author  Joshua Ruesweg
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\User\Notification\Object\Type
 * @since   5.1
 */
class ThreadModerationUserNotificationObjectType extends AbstractUserNotificationObjectType
{
    /**
     * @inheritDoc
     */
    protected static $decoratorClassName = ThreadModerationUserNotificationObject::class;

    /**
     * @inheritDoc
     */
    protected static $objectClassName = ModificationLog::class;

    /**
     * @inheritDoc
     */
    protected static $objectListClassName = ModificationLogList::class;
}
