/**
 * Handles the mark as read button for individual forums.
 *
 * @author  Matthias Schmidt, Marcel Werk
 * @copyright  2001-2022 WoltLab GmbH
 * @license  WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module  WoltLabSuite/Forum/Ui/Board/MarkAsRead
 */
define(["require", "exports", "tslib", "WoltLabSuite/Core/Ajax", "WoltLabSuite/Core/Dom/Util"], function (require, exports, tslib_1, Ajax_1, Util_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.setup = exports.setAsRead = void 0;
    Util_1 = tslib_1.__importDefault(Util_1);
    const unreadBoards = new WeakSet();
    async function markAsRead(board, button) {
        const boardId = parseInt(board.dataset.boardId, 10);
        await (0, Ajax_1.dboAction)("markAsRead", "wbb\\data\\board\\BoardAction").objectIds([boardId]).dispatch();
        updateElements(board, button);
    }
    function updateElements(board, button) {
        setAsRead(button);
        board.querySelectorAll("ul:first-of-type li").forEach((el) => {
            const button = el.querySelector(".markAsRead");
            if (button) {
                updateElements(el, button);
            }
        });
    }
    function setAsRead(button) {
        var _a;
        const board = button.closest("li");
        board.classList.remove("new");
        (_a = board.querySelector(".new")) === null || _a === void 0 ? void 0 : _a.classList.remove("new");
        button.classList.remove("markAsRead");
        board.querySelectorAll(".badge.badgeUpdate").forEach((badge) => {
            Util_1.default.hide(badge);
        });
        if (button.classList.contains("fa-folder-open")) {
            button.classList.remove("fa-folder-open");
            button.classList.add("fa-folder-open-o");
        }
        else if (button.classList.contains("fa-folder")) {
            button.classList.remove("fa-folder");
            button.classList.add("fa-folder-o");
        }
        button.removeAttribute("title");
    }
    exports.setAsRead = setAsRead;
    /**
     * Sets up the marking boards as read handler.
     */
    function setup() {
        document.querySelectorAll(".wbbBoardList .markAsRead").forEach((el) => {
            if (!unreadBoards.has(el)) {
                unreadBoards.add(el);
                el.addEventListener("dblclick", (event) => {
                    event.preventDefault();
                    if (!el.classList.contains("markAsRead")) {
                        return;
                    }
                    const board = el.closest("li");
                    void markAsRead(board, el);
                }, { once: true });
            }
        });
    }
    exports.setup = setup;
});
