<?php

/**
 * Update the subscriptions to the new format.
 *
 * @author Joshua Ruesweg
 * @copyright 2001-2022 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum
 */

use wcf\system\user\object\watch\UserObjectWatchHandler;
use wcf\system\WCF;

$objectTypeID = UserObjectWatchHandler::getInstance()->getObjectTypeID('com.woltlab.wbb.board');

$sql = "SELECT  COUNT(*)
        FROM    wcf1_user_object_watch
        WHERE   objectTypeID = ?";
$statement = WCF::getDB()->prepare($sql);
$statement->execute([
    $objectTypeID,
]);

if ($statement->fetchSingleColumn() > 0) {
    // First: Delete all entries in wbb1_board_user_status, to avoid problems if an update will be run twice.
    $sql = "DELETE FROM     wbb1_board_user_status
            WHERE           status = ?";
    $statement = WCF::getDB()->prepare($sql);
    $statement->execute([
        'threadsOnly',
    ]);

    // Second: Convert all watched threads into the new format.
    //
    // The query must ignore any duplicates that can happen when
    // a board is both ignored and subscribed by a user. In that
    // case ignoring the conflict will silently convert this into
    // "just" an ignore.
    $sql = "INSERT IGNORE INTO wbb1_board_user_status
                        (userID, boardID, status)
            SELECT      userID, objectID, 'threadsOnly'
            FROM        wcf1_user_object_watch
            WHERE       objectTypeID = ?
                    AND objectID IN (
                        SELECT  boardID
                        FROM    wbb1_board
                    )";
    $statement = WCF::getDB()->prepare($sql);
    $statement->execute([
        $objectTypeID,
    ]);

    // Third: Delete all entries in wcf1_user_object_watch, because they are no longer needeed.
    $sql = "DELETE FROM wcf1_user_object_watch
            WHERE       objectTypeID = ?";
    $statement = WCF::getDB()->prepare($sql);
    $statement->execute([
        $objectTypeID,
    ]);
}
