<?php

namespace wbb\page;

use wbb\data\board\DetailedBoardNodeList;
use wbb\system\cache\builder\StatsCacheBuilder;
use wbb\system\WBBCore;
use wcf\page\AbstractPage;
use wcf\system\cache\builder\UserStatsCacheBuilder;
use wcf\system\MetaTagHandler;
use wcf\system\request\LinkHandler;
use wcf\system\WCF;

/**
 * Shows the start page of the forum.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\Page
 */
class BoardListPage extends AbstractPage
{
    /**
     * board node list
     * @var DetailedBoardNodeList
     */
    public $boardNodeList;

    /**
     * simple forum statistics
     * @var array
     */
    public $stats = [];

    /**
     * @inheritDoc
     */
    public function readParameters()
    {
        parent::readParameters();

        $this->canonicalURL = LinkHandler::getInstance()->getLink('BoardList', ['application' => 'wbb']);
    }

    /**
     * @inheritDoc
     */
    public function readData()
    {
        parent::readData();

        // get node tree
        $this->boardNodeList = new DetailedBoardNodeList();
        $this->boardNodeList->readNodeTree();

        // stats
        if (WBB_INDEX_ENABLE_STATS && WCF::getSession()->getPermission('user.profile.canViewStatistics')) {
            $this->stats = \array_merge(
                StatsCacheBuilder::getInstance()->getData(),
                UserStatsCacheBuilder::getInstance()->getData()
            );
        }

        // add breadcrumbs
        WBBCore::getInstance()->setLocation();

        // set current page as 'website'
        if (WCF::isLandingPage()) {
            MetaTagHandler::getInstance()->addTag(
                'og:url',
                'og:url',
                LinkHandler::getInstance()->getLink('BoardList', ['application' => 'wbb']),
                true
            );
            MetaTagHandler::getInstance()->addTag(
                'og:type',
                'og:type',
                'website',
                true
            );
            MetaTagHandler::getInstance()->addTag(
                'og:title',
                'og:title',
                WCF::getLanguage()->get(PAGE_TITLE),
                true
            );
            MetaTagHandler::getInstance()->addTag(
                'og:description',
                'og:description',
                WCF::getLanguage()->get(PAGE_DESCRIPTION),
                true
            );
        }
    }

    /**
     * @inheritDoc
     */
    public function assignVariables()
    {
        parent::assignVariables();

        WCF::getTPL()->assign([
            'boardNodeList' => $this->boardNodeList->getNodeList(),
            'stats' => $this->stats,
        ]);
    }
}
