<?php

namespace wbb\system\background\job;

use wbb\data\thread\Thread;
use wbb\data\thread\ThreadAction;
use wcf\system\background\job\AbstractBackgroundJob;

/**
 * Represents a background job to update similar threads.
 *
 * @author      Joshua Ruesweg
 * @copyright   2001-2021 WoltLab GmbH
 * @license     WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package     WoltLabSuite\Forum\System\Background\Job
 * @since       5.5
 */
final class UpdateSimilarThreadsJob extends AbstractBackgroundJob
{
    /**
     * @var int
     */
    private $threadID;

    public function __construct(Thread $thread)
    {
        $this->threadID = $thread->threadID;
    }

    /**
     * @inheritDoc
     */
    public function retryAfter()
    {
        switch ($this->getFailures()) {
            case 1:
                // 30 minutes
                return 30 * 60;
            case 2:
                // 12 hours
                return 12 * 60 * 60;
            case 3:
                // 24 hours
                return 24 * 60 * 60;
        }
    }

    /**
     * @inheritDoc
     */
    public function perform()
    {
        $thread = new Thread($this->threadID);
        if ($thread->threadID) {
            $threadAction = new ThreadAction([$thread], 'updateSimilarThreads');
            $threadAction->executeAction();
        }
    }
}
