<?php

namespace wbb\system\event\listener;

use wbb\page\IThreadPage;
use wcf\data\page\PageCache;
use wcf\system\event\listener\IParameterizedEventListener;
use wcf\system\WCF;

/**
 * Assigns the page object types implementing IThreadPage to the template engine.
 *
 * @author  Matthias Schmidt
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Event\Listener
 * @since   5.0
 */
class ThreadConditionNoticeAddListener implements IParameterizedEventListener
{
    /**
     * @inheritDoc
     */
    public function execute($eventObj, $className, $eventName, array &$parameters)
    {
        $pageIDs = [];
        foreach (PageCache::getInstance()->getPages() as $page) {
            if (\is_subclass_of($page->controller, IThreadPage::class)) {
                $pageIDs[] = $page->pageID;
            }
        }

        WCF::getTPL()->assign('wbbThreadPageIDs', $pageIDs);
    }
}
