<?php

namespace wbb\data\modification\log;

use wbb\data\post\Post;
use wcf\data\DatabaseObjectDecorator;
use wcf\data\modification\log\IViewableModificationLog;
use wcf\data\modification\log\ModificationLog;
use wcf\data\user\UserProfile;
use wcf\system\cache\runtime\UserProfileRuntimeCache;
use wcf\system\WCF;

/**
 * Provides a viewable post modification log.
 *
 * @author  Alexander Ebert
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\Data\Modification\Log
 *
 * @method  ModificationLog     getDecoratedObject()
 * @mixin   ModificationLog
 */
class ViewablePostModificationLog extends DatabaseObjectDecorator implements IViewableModificationLog
{
    /**
     * @inheritDoc
     */
    protected static $baseClass = ModificationLog::class;

    /**
     * post object
     * @var Post
     */
    public $post;

    /**
     * user profile object
     * @var UserProfile
     */
    protected $userProfile;

    /**
     * Returns readable representation of current log entry.
     *
     * @return  string
     */
    public function __toString()
    {
        return WCF::getLanguage()->getDynamicVariable('wbb.thread.log.post.' . $this->action, [
            'additionalData' => $this->additionalData,
            'post' => $this->post,
        ]);
    }

    /**
     * Sets the post object.
     *
     * @param   Post    $post
     */
    public function setPost(Post $post)
    {
        if ($post->postID === $this->objectID) {
            $this->post = $post;
        }
    }

    /**
     * Returns the user profile object.
     *
     * @return  UserProfile
     */
    public function getUserProfile()
    {
        if ($this->userProfile === null) {
            if ($this->userID) {
                $this->userProfile = UserProfileRuntimeCache::getInstance()->getObject($this->userID);
            } else {
                $this->userProfile = UserProfile::getGuestUserProfile($this->username);
            }
        }

        return $this->userProfile;
    }

    /**
     * @inheritDoc
     */
    public function getAffectedObject()
    {
        return $this->post;
    }
}
