{include file='header' pageTitle='wbb.acp.rssFeed.list'}

<header class="contentHeader">
	<div class="contentHeaderTitle">
		<h1 class="contentTitle">{lang}wbb.acp.rssFeed.list{/lang}</h1>
		<p class="contentHeaderDescription">{lang}wbb.acp.rssFeed.description{/lang}</p>
	</div>
	
	<nav class="contentHeaderNavigation">
		<ul>
			<li><a href="{link application='wbb' controller='RssFeedAdd'}{/link}" class="button"><span class="icon icon16 fa-plus"></span> <span>{lang}wbb.acp.rssFeed.add{/lang}</span></a></li>
			
			{event name='contentHeaderNavigation'}
		</ul>
	</nav>
</header>

{hascontent}
	<div class="paginationTop">
		{content}{pages print=true assign=pagesLinks application="wbb" controller="RssFeedList" link="pageNo=%d&sortField=$sortField&sortOrder=$sortOrder"}{/content}
	</div>
{/hascontent}

{if $objects|count}
	<div id="rssFeedTableContainer" class="section tabularBox">
		<table class="table jsObjectActionContainer" data-object-action-class-name="wbb\data\rss\feed\RssFeedAction">
			<thead>
				<tr>
					<th class="columnID columnFeedID{if $sortField == 'feedID'} active {@$sortOrder}{/if}" colspan="2"><a href="{link application='wbb' controller='RssFeedList'}pageNo={@$pageNo}&sortField=feedID&sortOrder={if $sortField == 'feedID' && $sortOrder == 'ASC'}DESC{else}ASC{/if}{/link}">{lang}wcf.global.objectID{/lang}</a></th>
					<th class="columnTitle{if $sortField == 'title'} active {@$sortOrder}{/if}"><a href="{link application='wbb' controller='RssFeedList'}pageNo={@$pageNo}&sortField=title&sortOrder={if $sortField == 'title' && $sortOrder == 'ASC'}DESC{else}ASC{/if}{/link}">{lang}wcf.global.title{/lang}</a></th>
					<th class="columnDate columnLastRun{if $sortField == 'lastRun'} active {@$sortOrder}{/if}"><a href="{link application='wbb' controller='RssFeedList'}pageNo={@$pageNo}&sortField=lastRun&sortOrder={if $sortField == 'lastRun' && $sortOrder == 'ASC'}DESC{else}ASC{/if}{/link}">{lang}wbb.acp.rssFeed.lastRun{/lang}</a></th>
					
					{event name='columnHeads'}
				</tr>
			</thead>
			
			<tbody class="jsReloadPageWhenEmpty">
				{foreach from=$objects item=feed}
					<tr class="jsRssFeedRow jsObjectActionObject" data-object-id="{@$feed->getObjectID()}">
						<td class="columnIcon">
							{objectAction action="toggle" isDisabled=$feed->isDisabled}
							<a href="{link application='wbb' controller='RssFeedEdit' id=$feed->feedID}{/link}" title="{lang}wcf.global.button.edit{/lang}" class="jsTooltip"><span class="icon icon16 fa-pencil"></span></a>
							{objectAction action="delete" objectTitle=$feed->title}
							
							{event name='rowButtons'}
						</td>
						<td class="columnID">{@$feed->feedID}</td>
						<td class="columnTitle">
							<a href="{link application='wbb' controller='RssFeedEdit' id=$feed->feedID}{/link}">{$feed->title}</a>
							<p><small>{$feed->url}</small></p>
						</td>
						<td class="columnDate columnLastRun">
							{if $feed->errorMessage}<a href="{link application='wbb' controller='RssFeedEdit' id=$feed->feedID}{/link}"><span class="icon icon16 fa-exclamation-triangle jsTooltip" title="{lang}wbb.acp.rssFeed.errorMessage{/lang}"></span></a>{/if}
							{if $feed->lastRun}{@$feed->lastRun|time}{/if}
						</td>
						
						{event name='columns'}
					</tr>
				{/foreach}
			</tbody>
		</table>
	</div>
	
	<footer class="contentFooter">
		{hascontent}
			<div class="paginationBottom">
				{content}{@$pagesLinks}{/content}
			</div>
		{/hascontent}
		
		<nav class="contentFooterNavigation">
			<ul>
				<li><a href="{link application='wbb' controller='RssFeedAdd'}{/link}" class="button"><span class="icon icon16 fa-plus"></span> <span>{lang}wbb.acp.rssFeed.add{/lang}</span></a></li>
				
				{event name='contentFooterNavigation'}
			</ul>
		</nav>
	</footer>
{else}
	<p class="info">{lang}wcf.global.noItems{/lang}</p>
{/if}

{include file='footer'}
