/**
 * Handles the board watch button.
 *
 * @author  Joshua Ruesweg
 * @copyright  2001-2021 WoltLab GmbH
 * @license  WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module  WoltLabSuite/Forum/Controller/Board/SubscriptionStatusHandler
 */
define(["require", "exports", "tslib", "WoltLabSuite/Core/Ajax", "WoltLabSuite/Core/Ui/Notification", "WoltLabSuite/Core/Language", "WoltLabSuite/Core/Event/Handler"], function (require, exports, tslib_1, Ajax, UiNotification, Language, EventHandler) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.SubscriptionStatusHandler = void 0;
    Ajax = tslib_1.__importStar(Ajax);
    UiNotification = tslib_1.__importStar(UiNotification);
    Language = tslib_1.__importStar(Language);
    EventHandler = tslib_1.__importStar(EventHandler);
    class SubscriptionStatusHandler {
        constructor() {
            this.dropdowns = new Map();
            document.querySelectorAll(".subscribeBoardStatusDropdown").forEach((element) => {
                if (!element.dataset.boardId) {
                    throw new Error("Missing boardID for '.subscribeBoardStatusDropdown' element.");
                }
                const boardId = parseInt(element.dataset.boardId, 10);
                if (!this.dropdowns.has(boardId)) {
                    this.dropdowns.set(boardId, new Set());
                }
                this.dropdowns.get(boardId).add(element);
                element.querySelectorAll(".subscribeBoardSelect").forEach((element) => {
                    if (!element.dataset.status) {
                        throw new Error("Missing 'data-status' attribute for '.subscribeBoardSelect' element.");
                    }
                    element.addEventListener("click", (event) => void this.click(event));
                });
            });
        }
        async click(event) {
            event.preventDefault();
            const target = event.target;
            const dropdown = target.closest(".subscribeBoardStatusDropdown");
            const li = target.closest(".subscribeBoardSelect");
            const status = li.dataset.status;
            const boardID = parseInt(dropdown.dataset.boardId, 10);
            const response = (await Ajax.dboAction("saveSubscriptionStatus", "wbb\\data\\board\\BoardStatusAction")
                .payload({
                boardID,
                status,
            })
                .dispatch());
            if (this.dropdowns.has(response.boardID)) {
                this.dropdowns.get(response.boardID).forEach((element) => {
                    var _a;
                    element.querySelectorAll(".subscribeBoardSelect").forEach((li) => {
                        li.classList.remove("active");
                    });
                    (_a = element.querySelector(`.subscribeBoardSelect[data-status="${response.status}"]`)) === null || _a === void 0 ? void 0 : _a.classList.add("active");
                });
            }
            document
                .querySelectorAll(`.subscribeBoardStatusDropdownToggle[data-board-id="${response.boardID}"]`)
                .forEach((element) => {
                const icon = element.querySelector(".icon");
                const label = element.querySelector("span:not(.icon)");
                if (response.status !== "normal") {
                    element.classList.add("active");
                    icon.classList.remove("fa-bookmark", "fa-ban", "fa-bookmark-o");
                    icon.classList.add(response.status === "ignoring" ? "fa-ban" : "fa-bookmark");
                    label.textContent = Language.get("wbb.board.status." + (response.status === "ignoring" ? "ignoring" : "watching"));
                }
                else {
                    element.classList.remove("active");
                    icon.classList.remove("fa-bookmark", "fa-ban");
                    icon.classList.add("fa-bookmark-o");
                    label.textContent = Language.get("wcf.user.objectWatch.button.subscribe");
                }
                element.dataset.isSubscribed = response.status === "threadsOnly" ? "1" : "0";
            });
            EventHandler.fire("com.woltlab.wcf.objectWatch", "updatedSubscription");
            UiNotification.show();
        }
    }
    exports.SubscriptionStatusHandler = SubscriptionStatusHandler;
    exports.default = SubscriptionStatusHandler;
});
