/**
 * Executes global forum-related JavaScript code.
 *
 * @author  Matthias Schmidt
 * @copyright  2001-2021 WoltLab GmbH
 * @license  GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @module  WoltLabSuite/Forum/Bootstrap
 */
define(["require", "exports", "tslib", "WoltLabSuite/Core/Controller/Popover"], function (require, exports, tslib_1, Popover) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.setup = void 0;
    Popover = tslib_1.__importStar(Popover);
    function setupThreadPopover() {
        Popover.init({
            className: "wbbTopicLink",
            dboAction: "wbb\\data\\thread\\ThreadAction",
            identifier: "com.woltlab.wbb.thread",
            loadCallback: (objectId, popover, element) => {
                popover.ajaxApi({
                    actionName: "getPopover",
                    className: "wbb\\data\\thread\\ThreadAction",
                    objectIDs: [objectId],
                    parameters: {
                        sortOrder: element.dataset.sortOrder ? element.dataset.sortOrder : "ASC",
                    },
                }, (data) => {
                    popover.setContent("com.woltlab.wbb.thread", objectId, data.returnValues.template);
                });
            },
        });
        // @deprecated 5.3 use `data-object-id` or `anchor` template plugin
        Popover.init({
            attributeName: "data-thread-id",
            className: "wbbTopicLink",
            dboAction: "wbb\\data\\thread\\ThreadAction",
            identifier: "com.woltlab.wbb.thread.deprecated",
            loadCallback: (objectId, popover, element) => {
                popover.ajaxApi({
                    actionName: "getPopover",
                    className: "wbb\\data\\thread\\ThreadAction",
                    objectIDs: [objectId],
                    parameters: {
                        sortOrder: element.dataset.sortOrder ? element.dataset.sortOrder : "ASC",
                    },
                }, (data) => {
                    popover.setContent("com.woltlab.wbb.thread.deprecated", objectId, data.returnValues.template);
                });
            },
        });
    }
    function setupPostPopover() {
        Popover.init({
            className: "wbbPostLink",
            dboAction: "wbb\\data\\post\\PostAction",
            identifier: "com.woltlab.wbb.post",
        });
        // @deprecated 5.3 use `data-object-id` or `anchor` template plugin
        Popover.init({
            attributeName: "data-post-id",
            className: "wbbPostLink",
            dboAction: "wbb\\data\\post\\PostAction",
            identifier: "com.woltlab.wbb.post.deprecated",
        });
    }
    function setup() {
        setupThreadPopover();
        setupPostPopover();
    }
    exports.setup = setup;
});
