define(["require", "exports", "tslib", "WoltLabSuite/Core/Date/Picker", "WoltLabSuite/Core/Dom/Util", "WoltLabSuite/Core/Event/Handler", "WoltLabSuite/Core/Language"], function (require, exports, tslib_1, DatePicker, Util_1, EventHandler, Language) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.init = exports.reset = exports.handleError = exports.toggleEnableTime = void 0;
    DatePicker = tslib_1.__importStar(DatePicker);
    Util_1 = tslib_1.__importDefault(Util_1);
    EventHandler = tslib_1.__importStar(EventHandler);
    Language = tslib_1.__importStar(Language);
    const _messageQuickReply = document.getElementById("messageQuickReply");
    const _disablePost = document.getElementById("threadReplyDisablePost");
    function toggleEnableTime() {
        _messageQuickReply.querySelectorAll(".jsThreadQuickReplyEnableTime").forEach((element) => {
            if (_disablePost.checked) {
                Util_1.default.show(element);
            }
            else {
                Util_1.default.hide(element);
            }
        });
    }
    exports.toggleEnableTime = toggleEnableTime;
    function handleError(data) {
        if (data.returnValues.fieldName === "enableTime") {
            const datePickerElement = document.getElementById("threadReplyPostEnableTimeDatePicker");
            data.api.throwError(datePickerElement.nextElementSibling, Language.get(`wbb.post.enableTime.error.${data.returnValues.errorType}`));
            const tabMenu = datePickerElement.closest(".messageTabMenu");
            window.jQuery(tabMenu).messageTabMenu("showTab", "settings", true);
            data.cancel = true;
        }
    }
    exports.handleError = handleError;
    function reset() {
        DatePicker.clear("threadReplyPostEnableTime");
        _disablePost.checked = false;
        toggleEnableTime();
    }
    exports.reset = reset;
    function init() {
        _disablePost.addEventListener("click", toggleEnableTime);
        EventHandler.add("com.woltlab.wcf.redactor2", "handleError_text", handleError);
        EventHandler.add("com.woltlab.wcf.redactor2", "reset_text", reset);
    }
    exports.init = init;
});
