<?php

namespace wbb\system\moderation\queue\activation;

use wbb\data\post\Post;
use wbb\data\post\PostAction;
use wbb\data\post\ViewablePostList;
use wbb\system\moderation\queue\AbstractPostModerationQueueHandler;
use wbb\system\option\ThreadFormOptionHandler;
use wcf\data\moderation\queue\ModerationQueue;
use wcf\data\moderation\queue\ViewableModerationQueue;
use wcf\system\moderation\queue\activation\IModerationQueueActivationHandler;
use wcf\system\WCF;

/**
 * An implementation of IModerationQueueActivationHandler for forum posts.
 *
 * @author  Alexander Ebert
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Moderation\Queue\Activation
 */
class PostModerationQueueActivationHandler extends AbstractPostModerationQueueHandler implements
    IModerationQueueActivationHandler
{
    /**
     * @inheritDoc
     */
    protected $definitionName = 'com.woltlab.wcf.moderation.activation';

    /**
     * @inheritDoc
     */
    protected $objectType = 'com.woltlab.wbb.post';

    /**
     * @inheritDoc
     */
    public function enableContent(ModerationQueue $queue)
    {
        if ($this->isValid($queue->objectID) && $this->getPost($queue->objectID)->isDisabled) {
            $postAction = new PostAction([$this->getPost($queue->objectID)], 'enable');
            $postAction->executeAction();
        }
    }

    /**
     * @inheritDoc
     */
    public function getDisabledContent(ViewableModerationQueue $queue)
    {
        /** @var Post $affectedPost */
        $affectedPost = $queue->getAffectedObject();

        $list = new ViewablePostList();
        $list->setObjectIDs([$affectedPost->postID]);
        $list->readObjects();
        $post = $list->getSingleObject();

        // Fetch thread form options.
        if ($post->isFirstPost()) {
            $threadFormOptionHandler = new ThreadFormOptionHandler(false);
            $threadFormOptionHandler->setPost($post->getDecoratedObject());
            WCF::getTPL()->assign('threadFormOptions', $threadFormOptionHandler->getOptions());
        }

        WCF::getTPL()->assign([
            'post' => $post,
            'attachmentList' => $list->getAttachmentList(),
        ]);

        return WCF::getTPL()->fetch('moderationPost', 'wbb');
    }
}
