<?php

namespace wbb\system\moderation\queue\report;

use wbb\data\post\Post;
use wbb\data\post\ViewablePostList;
use wbb\system\moderation\queue\AbstractPostModerationQueueHandler;
use wbb\system\option\ThreadFormOptionHandler;
use wcf\data\moderation\queue\ViewableModerationQueue;
use wcf\system\moderation\queue\report\IModerationQueueReportHandler;
use wcf\system\WCF;

/**
 * An implementation of IModerationQueueReportHandler for forum posts.
 *
 * @author  Alexander Ebert
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Moderation\Queue\Report
 */
class PostModerationQueueReportHandler extends AbstractPostModerationQueueHandler implements
    IModerationQueueReportHandler
{
    /**
     * @inheritDoc
     */
    protected $definitionName = 'com.woltlab.wcf.moderation.report';

    /**
     * @inheritDoc
     */
    protected $objectType = 'com.woltlab.wbb.post';

    /**
     * @inheritDoc
     */
    public function canReport($objectID)
    {
        if (!$this->isValid($objectID)) {
            return false;
        }

        if (!$this->getPost($objectID)->canRead()) {
            return false;
        }

        return true;
    }

    /**
     * @inheritDoc
     */
    public function getReportedContent(ViewableModerationQueue $queue)
    {
        /** @var Post $affectedPost */
        $affectedPost = $queue->getAffectedObject();

        $list = new ViewablePostList();
        $list->setObjectIDs([$affectedPost->postID]);
        $list->readObjects();
        $post = $list->getSingleObject();

        // Fetch thread form options.
        if ($post->isFirstPost()) {
            $threadFormOptionHandler = new ThreadFormOptionHandler(false);
            $threadFormOptionHandler->setPost($post->getDecoratedObject());
            WCF::getTPL()->assign('threadFormOptions', $threadFormOptionHandler->getOptions());
        }

        WCF::getTPL()->assign([
            'post' => $post,
            'attachmentList' => $list->getAttachmentList(),
        ]);

        return WCF::getTPL()->fetch('moderationPost', 'wbb');
    }

    /**
     * @inheritDoc
     */
    public function getReportedObject($objectID)
    {
        if ($this->isValid($objectID)) {
            return $this->getPost($objectID);
        }

        return null;
    }
}
