<?php

namespace wbb\system\thread\editor;

use wbb\data\thread\Thread;

/**
 * Default interface for thread editors.
 *
 * @author  Alexander Ebert
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Thread\Editor
 */
interface IThreadEditor
{
    /**
     * Sets active thread.
     *
     * @param   Thread  $thread
     */
    public function setThread(Thread $thread);

    /**
     * Returns template for thread editor.
     *
     * @return  string
     */
    public function beginEdit();

    /**
     * Validates editor data.
     *
     * @param   array       $data
     */
    public function validate(array &$data);

    /**
     * Saves editor data.
     *
     * @param   array       $data
     * @return  array
     */
    public function saveEdit(array $data);
}
