<section class="section" id="threadEditorDefault">
	<h2 class="sectionTitle">{lang}wbb.post.information{/lang}</h2>
	
	<dl>
		<dt><label for="topic">{lang}wbb.post.subject{/lang}</label></dt>
		<dd>
			<input type="text" id="topic" value="{$thread->topic}" maxlength="255" class="long">
		</dd>
	</dl>
	
	{if $availableContentLanguages|count > 1}
		<dl>
			<dt>{lang}wcf.user.language{/lang}</dt>
			<dd id="threadEditorLanguageIDContainer"></dd>
		</dl>
	{/if}
	
	{hascontent}
		<dl role="group" aria-labelledby="threadTypeLabel">
			<dt><label id="threadTypeLabel">{lang}wbb.thread.type{/lang}</label></dt>
			<dd class="floated">
				<label><input type="radio" name="type" value="0"{if $type == 0} checked{/if}> {lang}wbb.thread.type.default{/lang}</label>
				{content}
					{if $board->getModeratorPermission('canPinThread')}<label><input type="radio" name="type" value="1"{if $type == 1} checked{/if}> {lang}wbb.thread.type.sticky{/lang}</label>{/if}
					{if $board->getModeratorPermission('canStartAnnouncement')}<label><input type="radio" name="type" value="2"{if $type == 2} checked{/if}> {lang}wbb.thread.type.announcement{/lang}</label>{/if}
				{/content}
			</dd>
			
			{if $board->getModeratorPermission('canStartAnnouncement') && $boardNodeList}
				<dt id="threadEditorAnnouncementLabel"><label for="boardIDs">{lang}wbb.thread.type.boardIDs{/lang}</label></dt>
				<dd id="threadEditorAnnouncementContainer">
					<select id="boardIDs" name="boardIDs[]" multiple size="10" class="long">
						{foreach from=$boardNodeList item=boardNode}
							<option value="{@$boardNode->getBoard()->boardID}"{if $boardNode->getBoard()->boardID|in_array:$boardIDs} selected{/if}>{if $boardNode->getDepth() > 1}{@"&nbsp;&nbsp;&nbsp;&nbsp;"|str_repeat:($boardNode->getDepth() - 1)}{/if}{$boardNode->getTitle()}</option>
						{/foreach}
					</select>
					<small>{lang}wcf.global.multiSelect{/lang}</small>
				</dd>
			{/if}
		</dl>
	{/hascontent}
	
	{event name='informationFields'}
</section>

<script data-relocate="true">
	$(function() {
		new WBB.Thread.Editor.Default();
		
		{if $availableContentLanguages|count > 1}
			var $languages = {
				{implode from=$availableContentLanguages item=contentLanguage}
					'{@$contentLanguage->languageID}': {
						iconPath: '{@$contentLanguage->getIconPath()|encodeJS}',
						languageName: '{@$contentLanguage|encodeJS}'
					}
				{/implode}
			};
			
			new WBB.Thread.Editor.Language('threadEditorLanguageIDContainer', 'threadLanguageID', {if $thread->languageID}{@$thread->languageID}{else}0{/if}, $languages);
		{/if}
	});
</script>

{event name='sections'}