<?php

use wcf\data\box\BoxAction;
use wcf\data\box\BoxList;
use wcf\data\object\type\ObjectTypeCache;
use wcf\system\WCF;

// reset the default sort field of the members list if it set to Burning Board specific field `wbbPosts`
$sql = "UPDATE  wcf" . WCF_N . "_option
        SET     optionValue = ?
        WHERE   optionName = ?
            AND optionValue = ?";
$statement = WCF::getDB()->prepareStatement($sql);
$statement->execute([
    'username',
    'members_list_default_sort_field',
    'wbbPosts',
]);

// delete user list boxes with `wbbPosts` as sort field
$boxList = new BoxList();
$boxList->getConditionBuilder()->add('box.objectTypeID = ?', [
    ObjectTypeCache::getInstance()
        ->getObjectTypeByName('com.woltlab.wcf.boxController', 'com.woltlab.wcf.userList')
        ->objectTypeID,
]);
$boxList->readObjects();

$deleteBoxes = [];
foreach ($boxList as $box) {
    if ($box->sortField === 'wbbPosts') {
        $deleteBoxes[] = $box;
    }
}

if (!empty($deleteBoxes)) {
    (new BoxAction($deleteBoxes, 'delete'))->executeAction();
}
