/**
 * Basic update handler for threads used in board view.
 *
 * @author  Joshua Ruesweg
 * @copyright  2001-2021 WoltLab GmbH
 * @license  WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module  WoltLabSuite/Forum/Handler/Thread/BoardUpdateHandler
 * @since 5.5
 */
define(["require", "exports", "tslib", "WoltLabSuite/Core/Dom/Util", "./UpdateHandler", "WoltLabSuite/Core/Language", "WoltLabSuite/Core/Controller/Clipboard"], function (require, exports, tslib_1, Util_1, UpdateHandler_1, Language, Clipboard) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.BoardUpdateHandler = void 0;
    Util_1 = tslib_1.__importDefault(Util_1);
    UpdateHandler_1 = tslib_1.__importDefault(UpdateHandler_1);
    Language = tslib_1.__importStar(Language);
    Clipboard = tslib_1.__importStar(Clipboard);
    class BoardUpdateHandler extends UpdateHandler_1.default {
        close(threadId) {
            const statusIcons = this.getThread(threadId).querySelector(".statusIcons");
            if (!statusIcons) {
                throw new Error(`".statusIcons" container not found for thread with id "${threadId}".`);
            }
            statusIcons.appendChild(getCloseIcon());
        }
        open(threadId) {
            this.getThread(threadId).querySelector(".jsIconClosed").closest("li").remove();
        }
        delete(threadId, _boardLink) {
            this.getThread(threadId).closest("li").remove();
            this.threads.delete(threadId);
            Clipboard.reload();
        }
        disable(threadId) {
            this.getThread(threadId).classList.add("messageDisabled");
        }
        enable(threadId) {
            this.getThread(threadId).classList.remove("messageDisabled");
        }
        done(threadId) {
            const doneIcon = this.getThread(threadId).querySelector(".jsMarkAsDone");
            if (!doneIcon) {
                throw new Error(`".jsMarkAsDone" icon not found for thread with id "${threadId}".`);
            }
            doneIcon.classList.remove("fa-square-o");
            doneIcon.classList.add("fa-check-square-o");
            doneIcon.title = Language.get("wbb.thread.done");
        }
        undone(threadId) {
            const doneIcon = this.getThread(threadId).querySelector(".jsMarkAsDone");
            if (!doneIcon) {
                throw new Error(`".jsMarkAsDone" icon not found for thread with id "${threadId}".`);
            }
            doneIcon.classList.remove("fa-check-square-o");
            doneIcon.classList.add("fa-square-o");
            doneIcon.title = Language.get("wbb.thread.undone");
        }
        moved(_threadId) {
            window.location.reload();
        }
        trash(threadId) {
            this.getThread(threadId).classList.add("messageDeleted");
        }
        restore(threadId) {
            var _a;
            this.getThread(threadId).classList.remove("messageDeleted");
            (_a = this.getThread(threadId).querySelector(".columnSubject > .wbbThreadDeleteNote")) === null || _a === void 0 ? void 0 : _a.remove();
        }
        showMoveNotice(threadId) {
            const avatarDiv = this.getThread(threadId).querySelector(".columnAvatar > div");
            if (!avatarDiv) {
                throw new Error(`".columnAvatar > div" icon not found for thread with id "${threadId}".`);
            }
            avatarDiv.appendChild(getMoveIcon());
        }
        sticky(_threadId) {
            // Does nothing.
        }
        scrape(_threadId) {
            // Does nothing.
        }
        updateTitle(_threadId, _title) {
            // Does nothing.
        }
    }
    exports.BoardUpdateHandler = BoardUpdateHandler;
    function getCloseIcon() {
        return Util_1.default.createFragmentFromHtml(`<li><span title="${Language.get("wbb.thread.closed")}" class="icon icon16 fa-lock jsTooltip jsIconClosed"></span></li>`);
    }
    function getMoveIcon() {
        return Util_1.default.createFragmentFromHtml(`<span title="${Language.get("wbb.thread.moved")}" class="icon icon16 fa-arrow-right jsTooltip jsIconMoved wbbMovedIcon"></span>`);
    }
    exports.default = BoardUpdateHandler;
});
