/**
 * Loads new or collapsed posts.
 *
 * @author  Alexander Ebert
 * @copyright  2001-2019 WoltLab GmbH
 * @license  WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module  WoltLabSuite/Forum/Ui/Post/Loader
 */
define(["require", "exports", "tslib", "WoltLabSuite/Core/Ajax", "WoltLabSuite/Core/Controller/Clipboard", "WoltLabSuite/Core/Dom/Change/Listener", "WoltLabSuite/Core/Dom/Util"], function (require, exports, tslib_1, Ajax, ControllerClipboard, Listener_1, Util_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.init = void 0;
    Ajax = tslib_1.__importStar(Ajax);
    ControllerClipboard = tslib_1.__importStar(ControllerClipboard);
    Listener_1 = tslib_1.__importDefault(Listener_1);
    Util_1 = tslib_1.__importDefault(Util_1);
    class UiPostLoader {
        constructor(postManager, postInlineEditor) {
            this.postInlineEditor = null;
            this.postManager = postManager;
            this.postInlineEditor = postInlineEditor;
            document.querySelectorAll(".wbbPostDeleted").forEach((post) => {
                post.addEventListener("click", (event) => this.click(event));
            });
        }
        /**
         * Handles clicks on collapsed posts.
         */
        click(event) {
            const target = event.target;
            if (target.nodeName === "A" || target.nodeName === "INPUT") {
                return;
            }
            const currentTarget = event.currentTarget;
            const postId = ~~currentTarget.dataset.objectId;
            this.load([postId]);
        }
        /**
         * Loads a list of posts by id.
         */
        load(postIds) {
            Ajax.api(this, {
                objectIDs: postIds,
            });
        }
        _ajaxSuccess(data) {
            var _a;
            const posts = document.createElement("div");
            Util_1.default.setInnerHtml(posts, data.returnValues.template);
            let lastPost = undefined;
            Array.from(posts.children).forEach((element) => {
                if (element.nodeName === "LI") {
                    lastPost = element;
                }
                else if (element.nodeName === "SCRIPT" && lastPost) {
                    lastPost.appendChild(element);
                    return;
                }
                const post = element.querySelector(".wbbPost");
                const objectId = post.dataset.objectId;
                const placeholder = document.getElementById(`post${objectId}`);
                placeholder.insertAdjacentElement("beforebegin", element);
                placeholder.remove();
            });
            this.postManager.rebuild();
            (_a = this.postInlineEditor) === null || _a === void 0 ? void 0 : _a.rebuild();
            ControllerClipboard.reload();
            Listener_1.default.trigger();
        }
        _ajaxSetup() {
            return {
                data: {
                    actionName: "getPosts",
                    className: "wbb\\data\\post\\PostAction",
                    parameters: {
                        showCollapsedPosts: true,
                    },
                },
            };
        }
    }
    let uiPostLoader;
    /**
     * Initializes the post loader.
     */
    function init(postManager, postInlineEditor) {
        if (!uiPostLoader) {
            uiPostLoader = new UiPostLoader(postManager, postInlineEditor);
        }
    }
    exports.init = init;
});
