<?php

namespace wbb\system\cronjob;

use wbb\data\post\PostAction;
use wbb\data\post\PostEditor;
use wbb\data\post\PostList;
use wcf\data\cronjob\Cronjob;
use wcf\system\cronjob\AbstractCronjob;
use wcf\system\WCF;

/**
 * Publishes delayed posts.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Cronjob
 */
class PublicationCronjob extends AbstractCronjob
{
    /**
     * @inheritDoc
     */
    public function execute(Cronjob $cronjob)
    {
        parent::execute($cronjob);

        $postList = new PostList();
        $postList->getConditionBuilder()->add('post.enableTime > ?', [0]);
        $postList->getConditionBuilder()->add('post.enableTime <= ?', [TIME_NOW]);
        $postList->getConditionBuilder()->add('post.isDisabled = ?', [1]);
        $postList->getConditionBuilder()->add('post.isDeleted = ?', [0]);
        $postList->decoratorClassName = PostEditor::class;
        $postList->readObjects();

        if (\count($postList->getObjects())) {
            // update timestamps
            $sql = "UPDATE  wbb" . WCF_N . "_thread
                    SET     time = ?,
                            lastPostTime = ?
                    WHERE   firstPostID = ?";
            $threadUpdateStatement = WCF::getDB()->prepareStatement($sql);
            $sql = "UPDATE  wbb" . WCF_N . "_post
                    SET     time = ?,
                            enableTime = ?
                    WHERE   postID = ?";
            $postUpdateStatement = WCF::getDB()->prepareStatement($sql);

            $postIDs = [];
            foreach ($postList->getObjects() as $post) {
                $threadUpdateStatement->execute([$post->enableTime, $post->enableTime, $post->postID]);
                $postUpdateStatement->execute([$post->enableTime, 0, $post->postID]);
                $postIDs[] = $post->postID;
            }

            // enable threads / posts
            $postList = new PostList();
            $postList->setObjectIDs($postIDs);
            $postList->decoratorClassName = PostEditor::class;
            $postList->readObjects();
            $action = new PostAction($postList->getObjects(), 'enable', [
                'ignorePostModificationLogs' => true,
            ]);
            $action->executeAction();
        }
    }
}
