<?php

namespace wbb\system\event\listener;

use wbb\data\thread\Thread;
use wcf\page\ArticlePage;
use wcf\system\event\listener\IParameterizedEventListener;
use wcf\system\WCF;

/**
 * Gets the article thread of the article.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Event\Listener
 */
class ArticlePageThreadListener implements IParameterizedEventListener
{
    /**
     * @inheritDoc
     */
    public function execute($eventObj, $className, $eventName, array &$parameters)
    {
        /** @var ArticlePage $eventObj */

        /** @noinspection PhpUndefinedFieldInspection */
        $threadID = $eventObj->articleContent->articleThreadID;
        if ($threadID) {
            WCF::getTPL()->assign(['articleThread' => new Thread($threadID)]);
        }
    }
}
