<?php

namespace wbb\system\event\listener;

use wbb\system\cache\builder\TopPosterCacheBuilder;
use wcf\system\box\UserListBoxController;
use wcf\system\event\listener\IParameterizedEventListener;

/**
 * Adds support for sorting by post count to the user list box controller.
 *
 * @author  Matthias Schmidt
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Event\Listener
 * @since   5.0
 */
class UserListBoxControllerListener implements IParameterizedEventListener
{
    /**
     * @inheritDoc
     */
    public function execute($eventObj, $className, $eventName, array &$parameters)
    {
        /** @var UserListBoxController $eventObj */
        $eventObj->validSortFields[] = 'wbbPosts';
        $eventObj->cacheBuilders['wbbPosts'] = TopPosterCacheBuilder::class;
    }
}
