<?php

namespace wbb\system\option;

use wbb\data\post\Post;
use wbb\data\thread\form\option\ThreadFormCache;
use wcf\system\option\CustomOptionHandler;

/**
 * Option handler implementation for the thread form.
 *
 * @author  Joshua Ruesweg
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Option
 * @since       5.2
 */
class ThreadFormOptionHandler extends CustomOptionHandler
{
    /**
     * board ID for the current option handler
     * @var int
     */
    protected $boardID;

    /**
     * post object for the current option handler
     * @var Post
     */
    protected $post;

    /**
     * @inheritDoc
     */
    public function init()
    {
        if (!$this->boardID) {
            throw new \RuntimeException('You must set the boardID before initialisation of this OptionHandler.');
        }

        $this->readCache();

        parent::init();
    }

    /**
     * @inheritDoc
     */
    protected function readCache()
    {
        if (!$this->boardID) {
            $this->cachedOptions = [];
        } else {
            $this->cachedOptions = ThreadFormCache::getInstance()->getThreadFormOptions($this->boardID);
        }
    }

    /**
     * Set the boardID for these OptionHandler.
     *
     * @param $boardID
     */
    public function setBoardID($boardID)
    {
        $this->boardID = $boardID;
    }

    /**
     * Sets option values for a certain thread.
     *
     * @param   Post          $post
     */
    public function setPost(Post $post)
    {
        $this->optionValues = [];
        $this->post = $post;
        $this->boardID = $post->getThread()->boardID;

        $this->init();
        foreach ($this->options as $option) {
            $this->optionValues[$option->optionName] = $this->post->getOptionValue($option->optionID);
        }
    }
}
