<script data-relocate="true">
    require(['WoltLabSuite/Core/Language', 'WoltLabSuite/Core/Ui/ItemList/Filter'], (Language, UiItemListFilter) => {
        Language.addObject({
            'wcf.global.filter.button.visibility': '{jslang}wcf.global.filter.button.visibility{/jslang}',
            'wcf.global.filter.button.clear': '{jslang}wcf.global.filter.button.clear{/jslang}',
            'wcf.global.filter.error.noMatches': '{jslang}wcf.global.filter.error.noMatches{/jslang}',
            'wcf.global.filter.placeholder': '{jslang}wcf.global.filter.placeholder{/jslang}',
            'wcf.global.filter.visibility.activeOnly': '{jslang}wcf.global.filter.visibility.activeOnly{/jslang}',
            'wcf.global.filter.visibility.highlightActive': '{jslang}wcf.global.filter.visibility.highlightActive{/jslang}',
            'wcf.global.filter.visibility.showAll': '{jslang}wcf.global.filter.visibility.showAll{/jslang}',
        });

        new UiItemListFilter('{@$field->getPrefixedId()}_list');
    });
</script>

<ul class="scrollableCheckboxList" id="{@$field->getPrefixedId()}_list">
    {foreach from=$field->getBoardNodeList()->getNodeList() item=boardNode}
        {if $field->supportsExternalLinks() || !$boardNode->getBoard()->isExternalLink()}
            <li{if $boardNode->getDepth() > 0} style="padding-left: {$boardNode->getDepth()*20-20}px"{/if}>
                <label>
                    <input {*
                        *}type="checkbox" {*
                        *}name="{@$field->getPrefixedId()}[]" {*
                        *}value="{@$boardNode->getObjectID()}"{*
                        *}{if !$field->getFieldClasses()|empty} class="{implode from=$field->getFieldClasses() item='class' glue=' '}{$class}{/implode}"{/if}{*
                        *}{if $field->getValue() !== null && $boardNode->getObjectID()|in_array:$field->getValue()} checked{/if}{*
                        *}{if $field->isImmutable() || (!$field->areCategoriesSelectable() && $boardNode->getBoard()->isCategory())} disabled{/if}{*
                        *}{foreach from=$field->getFieldAttributes() key='attributeName' item='attributeValue'} {$attributeName}="{$attributeValue}"{/foreach}{*
                    *}>
                    {$boardNode->getTitle()}
                </label>
            </li>
        {/if}
    {/foreach}
</ul>
