<?php

namespace wbb\acp\page;

use wbb\data\board\RealtimeBoardNodeList;
use wcf\page\AbstractPage;
use wcf\system\user\collapsible\content\UserCollapsibleContentHandler;
use wcf\system\WCF;

/**
 * Shows the board list.
 *
 * @author  Alexander Ebert
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\Acp\Page
 */
class BoardListPage extends AbstractPage
{
    /**
     * @inheritDoc
     */
    public $activeMenuItem = 'wbb.acp.menu.link.board.list';

    /**
     * @inheritDoc
     */
    public $neededPermissions = ['admin.board.canEditBoard', 'admin.board.canDeleteBoard'];

    /**
     * board node list
     * @var RealtimeBoardNodeList
     */
    public $boards;

    /**
     * list of collapsed category ids
     * @var int[]
     */
    public $collapsedCategoryIDs = [];

    /**
     * @inheritDoc
     */
    public function readData()
    {
        parent::readData();

        $this->boards = new RealtimeBoardNodeList();
        $this->boards->readNodeTree();

        $objectTypeID = UserCollapsibleContentHandler::getInstance()->getObjectTypeID('com.woltlab.wbb.acpBoard');
        $this->collapsedCategoryIDs = UserCollapsibleContentHandler::getInstance()->getCollapsedContent($objectTypeID);
    }

    /**
     * @inheritDoc
     */
    public function assignVariables()
    {
        parent::assignVariables();

        $boardNodeList = $this->boards->getNodeList();

        WCF::getTPL()->assign([
            'boardNodeList' => $boardNodeList,
            'collapsedCategoryIDs' => $this->collapsedCategoryIDs,
            'count' => \iterator_count($boardNodeList),
        ]);
    }
}
