<?php

namespace wbb\data\thread\form;

use wbb\data\thread\form\option\ThreadFormCache;
use wcf\data\DatabaseObjectEditor;
use wcf\data\IEditableCachedObject;

/**
 * Represents a thread form editor.
 *
 * @author  Joshua Ruesweg
 * @copyright   2001-2020 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\Data\Thread\Form
 * @since       5.3
 *
 * @method static   ThreadForm      create(array $parameters = [])
 * @method      ThreadForm      getDecoratedObject()
 * @mixin       ThreadForm
 */
class ThreadFormEditor extends DatabaseObjectEditor implements IEditableCachedObject
{
    /**
     * @inheritDoc
     */
    protected static $baseClass = ThreadForm::class;

    /**
     * @inheritDoc
     */
    public static function resetCache()
    {
        ThreadFormCache::getInstance()->resetCache();
    }
}
