<div id="wbbBoardSortFilter" class="jsStaticDialogContent" data-title="{lang}wbb.thread.filter{/lang}">
	<form method="post" action="{link application='wbb' controller='Board' object=$board}{/link}">
		{hascontent}
			<section class="section">
				<h2 class="sectionTitle">{lang}wcf.label.label{/lang}</h2>
				
				<dl>
					{content}
						{include file='__labelSelection' noLabelSelectionNoScript=true}
					{/content}
				</dl>
				
				<script data-relocate="true">
					$(function() {
						WCF.Language.addObject({
							'wcf.label.none': '{jslang}wcf.label.none{/jslang}',
							'wcf.label.withoutSelection': '{jslang}wcf.label.withoutSelection{/jslang}'
						});
						
						new WCF.Label.Chooser({ {implode from=$labelIDs key=groupID item=labelID}{@$groupID}: {@$labelID}{/implode} }, '#wbbBoardSortFilter', 'input[type="submit"]', true);
					});
				</script>
			</section>
		{/hascontent}
		
		<section class="section">
			<h2 class="sectionTitle">{lang}wbb.board.displayOptions{/lang}</h2>
			
			{if $availableLanguages|count}
				<dl>
					<dt><label>{lang}wcf.user.language{/lang}</label></dt>
					<dd id="languageIDContainer">
						<script data-relocate="true">
							require(['WoltLabSuite/Core/Language/Chooser'], function(LanguageChooser) {
								var languages = {
									{implode from=$availableLanguages item=_language}
									'{@$_language->languageID}': {
										iconPath: '{@$_language->getIconPath()|encodeJS}',
										languageName: '{@$_language|encodeJS}'
									}
									{/implode}
								};
								
								LanguageChooser.init('languageIDContainer', 'languageID', {$languageID}, languages, undefined, true)
							});
						</script>
					
					</dd>
				</dl>
			{/if}
			
			<dl>
				<dt><label for="filterByDate">{lang}wbb.board.filterByDate{/lang}</label></dt>
				<dd>
					<select id="filterByDate" name="filterByDate">
						<option value="1"{if $filterByDate == 1} selected{/if}>{lang}wbb.board.filterByDate.1{/lang}</option>
						<option value="3"{if $filterByDate == 3} selected{/if}>{lang}wbb.board.filterByDate.3{/lang}</option>
						<option value="7"{if $filterByDate == 7} selected{/if}>{lang}wbb.board.filterByDate.7{/lang}</option>
						<option value="14"{if $filterByDate == 14} selected{/if}>{lang}wbb.board.filterByDate.14{/lang}</option>
						<option value="30"{if $filterByDate == 30} selected{/if}>{lang}wbb.board.filterByDate.30{/lang}</option>
						<option value="60"{if $filterByDate == 60} selected{/if}>{lang}wbb.board.filterByDate.60{/lang}</option>
						<option value="100"{if $filterByDate == 100} selected{/if}>{lang}wbb.board.filterByDate.100{/lang}</option>
						<option value="365"{if $filterByDate == 365} selected{/if}>{lang}wbb.board.filterByDate.365{/lang}</option>
						<option value="1000"{if $filterByDate == 1000} selected{/if}>{lang}wbb.board.filterByDate.1000{/lang}</option>
					</select>
				</dd>
			</dl>
			
			<dl>
				<dt><label for="filterByStatus">{lang}wbb.board.filterByStatus{/lang}</label></dt>
				<dd>
					<select id="filterByStatus" name="filterByStatus">
						<option value="">{lang}wcf.global.noSelection{/lang}</option>
						<option value="read"{if $filterByStatus == 'read'} selected{/if}>{lang}wbb.board.filterByStatus.read{/lang}</option>
						<option value="unread"{if $filterByStatus == 'unread'} selected{/if}>{lang}wbb.board.filterByStatus.unread{/lang}</option>
						{if WBB_MODULE_THREAD_MARKING_AS_DONE && $board->enableMarkingAsDone}
							<option value="done"{if $filterByStatus == 'done'} selected{/if}>{lang}wbb.board.filterByStatus.done{/lang}</option>
							<option value="undone"{if $filterByStatus == 'undone'} selected{/if}>{lang}wbb.board.filterByStatus.undone{/lang}</option>
						{/if}
						<option value="closed"{if $filterByStatus == 'closed'} selected{/if}>{lang}wbb.board.filterByStatus.closed{/lang}</option>
						<option value="open"{if $filterByStatus == 'open'} selected{/if}>{lang}wbb.board.filterByStatus.open{/lang}</option>
						{if $board->getModeratorPermission('canReadDeletedThread')}
							<option value="deleted"{if $filterByStatus == 'deleted'} selected{/if}>{lang}wbb.board.filterByStatus.deleted{/lang}</option>
						{/if}
						{if $board->getModeratorPermission('canEnableThread')}
							<option value="disabled"{if $filterByStatus == 'disabled'} selected{/if}>{lang}wbb.board.filterByStatus.disabled{/lang}</option>
						{/if}
						{event name='filterByStatusOptions'}
					</select>
				</dd>
			</dl>
		</section>
		
		<div class="formSubmit">
			<input type="submit" value="{lang}wcf.global.button.submit{/lang}" accesskey="s">
			<input type="hidden" name="tagID" value="{@$tagID}">
			<input type="hidden" name="sortField" value="{$sortField}">
			<input type="hidden" name="sortOrder" value="{$sortOrder}">
		</div>
	</form>
</div>
<script data-relocate="true">
	require(['EventHandler'], function (EventHandler) {
		var container = elById('wbbBoardSortFilter');
		EventHandler.add('com.woltlab.wcf.dialog', 'openStatic', function (data) {
			if (data.id === 'wbbBoardSortFilter') {
				var isSingleSection = (elBySelAll('form > .section', data.content).length === 1);
				container.classList[isSingleSection ? 'add' : 'remove']('jsBoardSortFilterSingleSection');
			}
		});
	});
</script>
