<article class="message messageReduced jsMessage wbbPost"
         data-object-id="{@$post->postID}" data-post-id="{@$post->postID}" data-can-edit="0" data-can-edit-inline="1"
         data-is-closed="{if $post->isClosed}1{else}0{/if}" data-is-deleted="{if $post->isDeleted}1{else}0{/if}" data-is-disabled="{if $post->isDisabled}1{else}0{/if}"
         data-can-close="{@$post->getThread()->getBoard()->getModeratorPermission('canClosePost')}" data-can-delete="{@$post->getThread()->getBoard()->getModeratorPermission('canDeletePost')}" data-can-delete-completely="{@$post->getThread()->getBoard()->getModeratorPermission('canDeletePostCompletely')}" data-can-enable="0" data-can-restore="{@$post->getThread()->getBoard()->getModeratorPermission('canRestorePost')}"
>
	<div class="messageContent">
		<header class="messageHeader">
			<div class="box32 messageHeaderWrapper">
				{user object=$post->getUserProfile() type='avatar32' ariaHidden='true' tabindex='-1'}

				<div class="messageHeaderBox">
					<h2 class="messageTitle">
						<a href="{@$post->getLink()}">{$post->getTitle()}</a>
					</h2>

					<ul class="messageHeaderMetaData">
						<li>{user object=$post->getUserProfile() class='username'}</li>
						<li><span class="messagePublicationTime">{@$post->getTime()|time}</span></li>
						<li><a href="{$post->getThread()->getBoard()->getLink()}">{$post->getThread()->getBoard()->getTitle()}</a></li>

						{event name='messageHeaderMetaData'}
					</ul>

					<ul class="messageStatus">
						{if $post->isDeleted}<li><span class="badge label red jsIconDeleted">{lang}wcf.message.status.deleted{/lang}</span></li>{/if}
						{if $post->isDisabled}
							{if $post->enableTime}
								<li><span class="badge label">{lang}wcf.moderation.type.com.woltlab.wcf.moderation.activation.delayed{/lang}</span></li>
							{else}
								<li><span class="badge label green jsIconDisabled">{lang}wcf.message.status.disabled{/lang}</span></li>
							{/if}
						{/if}

						{event name='messageStatus'}
					</ul>
				</div>
			</div>
		</header>

		<div class="messageBody">
			{if $post->isFirstPost() && !$threadFormOptions|empty}
				{hascontent}
					<div class="threadFormOptions">
						{content}{include file="threadFormOptions" application="wbb"}{/content}
					</div>
				{/hascontent}
			{/if}

			{event name='beforeMessageText'}

			<div class="messageText">
				{@$post->getFormattedMessage()}
			</div>

			{event name='afterMessageText'}
		</div>

		<footer class="messageFooter">
			{include file='attachments' objectID=$post->postID}

			{event name='messageFooter'}

			<div class="messageFooterNotes">
				{if $post->isDisabled && $post->enableTime}
					<p class="messageFooterNote">{lang}wbb.post.delayedPublication{/lang}</p>
				{/if}

				{event name='messageFooterNotes'}
			</div>

			<div class="messageFooterGroup">
				<ul class="messageFooterButtons buttonList smallButtons">
					{if $post->getThread()->getBoard()->getModeratorPermission('canClosePost') || $post->getThread()->getBoard()->getModeratorPermission('canDeletePost') || $post->getThread()->getBoard()->getModeratorPermission('canDeletePostCompletely') || $post->getThread()->getBoard()->getModeratorPermission('canRestorePost')}
						{if $post->getThread()->canEditPost($post->getDecoratedObject())}<li><a href="#" title="{lang}wbb.post.edit{/lang}" class="button jsMessageEditButton"><span class="icon icon16 fa-pencil"></span> <span>{lang}wcf.global.button.edit{/lang}</span></a></li>{/if}
					{/if}
					{if LOG_IP_ADDRESS && $post->ipAddress && $__wcf->session->getPermission('admin.user.canViewIpAddress')}<li class="jsIpAddress jsOnly" data-post-id="{@$post->postID}"><a href="#" title="{lang}wbb.post.ipAddress{/lang}" class="button jsTooltip"><span class="icon icon16 fa-globe"></span> <span class="invisible">{lang}wbb.post.ipAddress{/lang}</span></a></li>{/if}
					{if MODULE_USER_INFRACTION && $post->getUserProfile()->userID && $__wcf->session->getPermission('mod.infraction.warning.canWarn') && !$post->getUserProfile()->getPermission('mod.infraction.warning.immune')}<li class="jsWarnPost jsOnly" data-object-id="{@$post->postID}" data-user-id="{@$post->getUserProfile()->userID}"><a href="#" title="{lang}wcf.infraction.warn{/lang}" class="button jsTooltip"><span class="icon icon16 fa-gavel"></span> <span class="invisible">{lang}wcf.infraction.warn{/lang}</span></a></li>{/if}
					{event name='messageFooterButtons'}
				</ul>
			</div>
		</footer>
	</div>
</article>

<script data-relocate="true" src="{@$__wcf->getPath()}js/WCF.Infraction{if !ENABLE_DEBUG_MODE}.min{/if}.js?v={@LAST_UPDATE_TIME}"></script>
<script data-relocate="true">
	$(function() {
		WCF.Language.addObject({
			'wcf.infraction.warn': '{jslang}wcf.infraction.warn{/jslang}',
			'wcf.infraction.warn.success': '{jslang}wcf.infraction.warn.success{/jslang}'
		});
		new WCF.Infraction.Warning.Content('com.woltlab.wbb.warnablePost', '.jsWarnPost');
	});

	{if LOG_IP_ADDRESS && $__wcf->session->getPermission('admin.user.canViewIpAddress')}
		require(['WoltLabSuite/Forum/Ui/Post/IpAddressHandler', 'Language'], ({ IpAddressHandler }, Language) => {
			Language.addObject({
				'wbb.post.ipAddress.title': '{jslang}wbb.post.ipAddress.title{/jslang}',
			});

			new IpAddressHandler();
		});
	{/if}
</script>
<script data-relocate="true">
	require(['Language', 'WoltLabSuite/Forum/Ui/Post/InlineEditor', 'WoltLabSuite/Forum/Ui/Post/Manager'], function (Language, UiPostInlineEditor, UiPostManager) {
		Language.addObject({
			'wbb.post.edit.close': '{jslang}wbb.post.edit.close{/jslang}',
			'wbb.post.edit.delete': '{jslang}wbb.post.edit.trash{/jslang}',
			'wbb.post.edit.delete.confirmMessage': '{jslang}wbb.post.edit.delete.confirmMessage{/jslang}',
			'wbb.post.edit.deleteCompletely': '{jslang}wbb.post.edit.delete{/jslang}',
			'wbb.post.edit.open': '{jslang}wbb.post.edit.open{/jslang}',
			'wbb.post.edit.restore': '{jslang}wbb.post.edit.restore{/jslang}',
			'wbb.post.edit.trash.confirmMessage': '{jslang}wbb.post.edit.trash.confirmMessage{/jslang}',
			'wbb.post.edit.trash.reason': '{jslang}wbb.post.edit.trash.reason{/jslang}',
			'wcf.message.status.deleted': '{jslang}wcf.message.status.deleted{/jslang}',
			'wcf.message.status.disabled': '{jslang}wcf.message.status.disabled{/jslang}'
		});

		new UiPostInlineEditor(0, new UiPostManager(), { disableEdit: true });
	});
</script>
