<?php

namespace wbb\system\cache\builder;

use wcf\system\cache\builder\AbstractCacheBuilder;
use wcf\system\WCF;

/**
 * Caches the amount posts and threads and the posts per day.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Cache\Builder
 */
class StatsCacheBuilder extends AbstractCacheBuilder
{
    /**
     * @inheritDoc
     */
    protected $maxLifetime = 600;

    /**
     * @inheritDoc
     */
    protected function rebuild(array $parameters)
    {
        $data = [];

        // amount of posts
        $sql = "SELECT  COUNT(*) AS amount
                FROM    wbb" . WCF_N . "_post";
        $statement = WCF::getDB()->prepareStatement($sql);
        $statement->execute();
        $data['posts'] = $statement->fetchColumn();

        // amount of threads
        $sql = "SELECT  COUNT(*) AS amount
                FROM    wbb" . WCF_N . "_thread";
        $statement = WCF::getDB()->prepareStatement($sql);
        $statement->execute();
        $data['threads'] = $statement->fetchColumn();

        // posts per day
        $days = \ceil((TIME_NOW - WBB_INSTALL_DATE) / 86400);
        if ($days <= 0) {
            $days = 1;
        }
        $data['postsPerDay'] = $data['posts'] / $days;

        return $data;
    }
}
