<?php

namespace wbb\system\condition\post;

use wbb\data\post\Post;
use wcf\system\condition\AbstractTimestampCondition;

/**
 * Condition implementation for a timestamp property of a post.
 *
 * @author  Matthias Schmidt
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Condition\Post
 * @since   5.0
 */
class PostTimestampPropertyCondition extends AbstractTimestampCondition
{
    /**
     * @inheritDoc
     */
    protected $className = Post::class;

    /**
     * @inheritDoc
     */
    protected function getLanguageItemPrefix()
    {
        return 'wbb.post.condition';
    }

    /**
     * @inheritDoc
     */
    protected function getPropertyName()
    {
        if (empty($this->propertyName)) {
            /** @noinspection PhpUndefinedFieldInspection */
            $propertyName = $this->getDecoratedObject()->propertyname;

            if ($propertyName) {
                $this->propertyName = $propertyName;
            } else {
                $objectTypePieces = \explode('.', $this->getDecoratedObject()->objectType);
                $this->propertyName = \end($objectTypePieces);
            }
        }

        return $this->propertyName;
    }
}
