define(["require", "exports", "tslib", "WoltLabSuite/Core/Ajax", "WoltLabSuite/Core/Date/Picker", "WoltLabSuite/Core/Dom/Util", "WoltLabSuite/Core/Language", "WoltLabSuite/Core/Ui/Dialog"], function (require, exports, tslib_1, Ajax, Picker_1, Util_1, Language, Dialog_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.init = void 0;
    Ajax = tslib_1.__importStar(Ajax);
    Picker_1 = tslib_1.__importDefault(Picker_1);
    Util_1 = tslib_1.__importDefault(Util_1);
    Language = tslib_1.__importStar(Language);
    Dialog_1 = tslib_1.__importDefault(Dialog_1);
    class UiThreadEnable {
        open(objectId, callback) {
            this.objectId = objectId;
            this.callback = callback;
            Ajax.api(this, {
                objectIDs: [this.objectId],
            });
        }
        submit(event) {
            event.preventDefault();
            const enableNow = document.getElementById("threadEnable_enableNow");
            if (enableNow.checked) {
                const enableNowAndUpdateTime = document.getElementById("threadEnable_enableNowAndUpdateTime");
                this.callback(true, enableNowAndUpdateTime.checked);
                Dialog_1.default.close(this);
            }
            else {
                Ajax.api(this, {
                    actionName: "setEnableTime",
                    parameters: {
                        enableTime: Picker_1.default.getValue("threadEnable_enableTime"),
                    },
                });
            }
        }
        _ajaxSuccess(data) {
            if (data.actionName === "prepareEnable") {
                Dialog_1.default.open(this, data.returnValues.template);
            }
            else {
                this.callback(false);
                Dialog_1.default.close(this);
            }
        }
        _ajaxSetup() {
            return {
                data: {
                    actionName: "prepareEnable",
                    className: "wbb\\data\\thread\\ThreadAction",
                    objectIDs: [this.objectId],
                },
            };
        }
        _dialogSetup() {
            return {
                id: "wbbThreadEnable",
                options: {
                    onClose() {
                        Picker_1.default.destroy("threadEnable_enableTime");
                    },
                    onShow: (content) => {
                        const enableNow = document.getElementById("threadEnable_enableNow");
                        const enableNowAndUpdateTime = document.getElementById("threadEnable_enableNowAndUpdateTime");
                        enableNow.addEventListener("change", () => {
                            Util_1.default.toggle(document.getElementById("threadEnable_enableTimeContainer"));
                            enableNowAndUpdateTime.disabled = !enableNowAndUpdateTime.disabled;
                        });
                        const button = content.querySelector(".formSubmit > button");
                        button.addEventListener("click", (event) => this.submit(event));
                    },
                    title: Language.get("wbb.thread.edit.enable"),
                },
                source: null,
            };
        }
    }
    let uiThreadEnable;
    function init(objectId, callback) {
        if (!uiThreadEnable) {
            uiThreadEnable = new UiThreadEnable();
        }
        uiThreadEnable.open(objectId, callback);
    }
    exports.init = init;
});
