/**
 * Handles the mark as read button for individual forums.
 *
 * @author  Marcel Werk
 * @copyright  2001-2022 WoltLab GmbH
 * @license  WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module  WoltLabSuite/Forum/Ui/Board/MarkAllThreadsAsRead
 */
define(["require", "exports", "tslib", "WoltLabSuite/Core/Ajax", "WoltLabSuite/Core/Ui/Notification", "./MarkAsRead"], function (require, exports, tslib_1, Ajax_1, UiNotification, BoardMarkAsRead) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.setup = void 0;
    UiNotification = tslib_1.__importStar(UiNotification);
    BoardMarkAsRead = tslib_1.__importStar(BoardMarkAsRead);
    async function markAsRead(boardId) {
        await (0, Ajax_1.dboAction)("markAsRead", "wbb\\data\\board\\BoardAction").objectIds([boardId]).dispatch();
        document.querySelectorAll(".wbbThreadList .new").forEach((el) => {
            el.classList.remove("new");
        });
        const boardList = document.querySelector(".wbbBoardList");
        if (boardList) {
            boardList.querySelectorAll(".markAsRead").forEach((el) => {
                BoardMarkAsRead.setAsRead(el);
            });
        }
        UiNotification.show();
    }
    function setup(boardId) {
        document.querySelectorAll(".markAsReadButton").forEach((el) => {
            el.addEventListener("click", (event) => {
                event.preventDefault();
                void markAsRead(boardId);
            });
        });
    }
    exports.setup = setup;
});
