/**
 * Hides modification log entries.
 *
 * @author  Joshua Ruesweg
 * @copyright  2001-2019 WoltLab GmbH
 * @license  WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module  WoltLabSuite/Forum/Ui/Thread/Modification/Log/Hide
 */
define(["require", "exports", "tslib", "WoltLabSuite/Core/Ajax", "WoltLabSuite/Core/Core", "WoltLabSuite/Core/Dom/Change/Listener", "WoltLabSuite/Core/Language", "WoltLabSuite/Core/Ui/Confirmation", "WoltLabSuite/Core/Ui/Notification"], function (require, exports, tslib_1, Ajax, Core, Listener_1, Language, UiConfirmation, UiNotification) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.init = void 0;
    Ajax = tslib_1.__importStar(Ajax);
    Core = tslib_1.__importStar(Core);
    Listener_1 = tslib_1.__importDefault(Listener_1);
    Language = tslib_1.__importStar(Language);
    UiConfirmation = tslib_1.__importStar(UiConfirmation);
    UiNotification = tslib_1.__importStar(UiNotification);
    class UiThreadModificationLogHide {
        constructor() {
            document.querySelectorAll(".jsModificationLogEntryHideButton").forEach((entry) => {
                entry.addEventListener("click", (event) => this.click(event));
            });
        }
        /**
         * Handles clicks on hide button.
         */
        click(event) {
            event.preventDefault();
            const button = event.currentTarget;
            if (Core.stringToBool(button.dataset.isSummarized)) {
                const logIDs = button.dataset.logIds;
                UiConfirmation.show({
                    confirm: () => this.hide(JSON.parse(logIDs)),
                    message: Language.get("wbb.thread.modification.log.thread.hide.confirmMessage"),
                });
            }
            else {
                const logID = ~~button.dataset.logId;
                UiConfirmation.show({
                    confirm: () => this.hide([logID]),
                    message: Language.get("wbb.thread.modification.log.thread.hide.confirmMessage"),
                });
            }
        }
        hide(logIDs) {
            Ajax.api(this, {
                objectIDs: logIDs,
            });
        }
        _ajaxSuccess(data) {
            data.returnValues.logIDs.forEach((logID) => {
                const entry = document.querySelector(`.modificationLogEntry[data-log-id="${logID}"]`);
                entry === null || entry === void 0 ? void 0 : entry.remove();
            });
            const postList = document.querySelector(".wbbThreadPostList");
            postList.querySelectorAll(".modificationLogEntry").forEach((element) => {
                const nextElement = element.nextElementSibling;
                if (!nextElement || !nextElement.classList.contains("modificationLogEntry")) {
                    element.classList.add("lastModificationLogEntry");
                }
            });
            Listener_1.default.trigger();
            UiNotification.show();
        }
        _ajaxSetup() {
            return {
                data: {
                    actionName: "hide",
                    className: "wbb\\data\\modification\\log\\ThreadModificationLogAction",
                },
            };
        }
    }
    let modificationLogHide;
    function init() {
        if (!modificationLogHide) {
            modificationLogHide = new UiThreadModificationLogHide();
        }
    }
    exports.init = init;
});
