<?php

namespace wbb\system\event\listener;

use wcf\system\event\listener\AbstractUserActionRenameListener;

/**
 * Updates the stored username on user rename.
 *
 * @author  Alexander Ebert
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Event\Listener
 */
class UserActionRenameListener extends AbstractUserActionRenameListener
{
    /**
     * @inheritDoc
     */
    protected $databaseTables = [
        'wbb{WCF_N}_post',
        [
            'name' => 'wbb{WCF_N}_post',
            'userID' => 'editorID',
            'username' => 'editor',
        ],
        'wbb{WCF_N}_thread',
        [
            'name' => 'wbb{WCF_N}_thread',
            'userID' => 'lastPosterID',
            'username' => 'lastPoster',
        ],
    ];
}
