/**
 * Provides the thread form option add dialog.
 *
 * @author  Joshua Ruesweg
 * @copyright  2001-2019 WoltLab GmbH
 * @license  WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module  WoltLabSuite/Forum/Acp/Ui/Board/Thread/Form/Option/Add
 * @since       5.2
 */
define(["require", "exports", "tslib", "WoltLabSuite/Core/Ajax", "WoltLabSuite/Core/Language", "./DialogHandler", "WoltLabSuite/Core/Dom/Util"], function (require, exports, tslib_1, Ajax, Language, DialogHandler, Util_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.init = void 0;
    Ajax = tslib_1.__importStar(Ajax);
    Language = tslib_1.__importStar(Language);
    DialogHandler = tslib_1.__importStar(DialogHandler);
    Util_1 = tslib_1.__importDefault(Util_1);
    class AcpUiBoardThreadFormOptionAdd {
        constructor(tmpHash, formId) {
            const button = document.getElementById("addThreadFormOptionButton");
            button.addEventListener("click", (event) => this.loadDialog(event));
            this.tmpHash = tmpHash;
            this.formId = formId;
        }
        /**
         * Open the dialog to add a option.
         */
        loadDialog(event) {
            event.preventDefault();
            DialogHandler.loadDialog((data) => this.saveDialog(data), undefined, Language.get("wbb.acp.board.threadForm.option.add"));
        }
        /**
         * Adds the option for the current dialog.
         */
        saveDialog(dialogData) {
            Ajax.api(this, {
                parameters: {
                    data: Object.assign({ tmpHash: this.tmpHash, formID: this.formId }, dialogData),
                },
            });
        }
        /**
         * Insert a new option to the options list.
         */
        _insertOptionToList(optionId, optionName) {
            const optionListDiv = document.getElementById("threadFormOptions");
            const optionList = optionListDiv.querySelector("ol");
            const liElement = document.createElement("li");
            liElement.classList.add("sortableNode", "sortableNoNesting", "jsObjectActionObject");
            liElement.dataset.objectId = optionId.toString();
            const spanElement = document.createElement("span");
            spanElement.classList.add("sortableNodeLabel");
            const optionNameSpan = document.createElement("span");
            optionNameSpan.textContent = optionName;
            spanElement.appendChild(optionNameSpan);
            const optionsSpan = document.createElement("span");
            optionsSpan.classList.add("statusDisplay", "sortableButtonContainer");
            const editSpan = document.createElement("span");
            editSpan.classList.add("icon", "icon16", "fa-pencil", "pointer", "jsEditButton", "jsTooltip");
            editSpan.title = Language.get("wcf.global.button.edit");
            editSpan.dataset.objectId = optionId.toString();
            optionsSpan.appendChild(editSpan);
            const removeSpan = document.createElement("span");
            removeSpan.classList.add("icon", "icon16", "fa-times", "pointer", "jsObjectAction", "jsTooltip");
            removeSpan.title = Language.get("wcf.global.button.delete");
            removeSpan.dataset.objectAction = "delete";
            removeSpan.dataset.confirmMessage = Language.get("wcf.button.delete.confirmMessage", {
                objectTitle: optionName,
            });
            optionsSpan.appendChild(removeSpan);
            spanElement.appendChild(optionsSpan);
            liElement.appendChild(spanElement);
            optionList.appendChild(liElement);
        }
        _ajaxSuccess(data) {
            if (data.actionName === "create") {
                Util_1.default.show(document.getElementById("threadFormOptions"));
                Util_1.default.hide(document.getElementById("threadFormNoOptionsInfo"));
                this._insertOptionToList(data.returnValues.optionID, data.returnValues.optionTitle);
                DialogHandler.closeDialog();
            }
        }
        _ajaxSetup() {
            return {
                data: {
                    className: "wbb\\data\\thread\\form\\option\\ThreadFormOptionAction",
                    actionName: "create",
                },
            };
        }
    }
    let formOptionAdd;
    function init(tmpHash, formId) {
        if (!formOptionAdd) {
            formOptionAdd = new AcpUiBoardThreadFormOptionAdd(tmpHash, formId);
        }
    }
    exports.init = init;
});
