/**
 * Handles edit on thread form options.
 *
 * @author  Joshua Ruesweg
 * @copyright  2001-2019 WoltLab GmbH
 * @license  WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module  WoltLabSuite/Forum/Acp/Ui/Board/Thread/Form/Option/Edit
 * @since       5.2
 */
define(["require", "exports", "tslib", "WoltLabSuite/Core/Ajax", "./DialogHandler", "WoltLabSuite/Core/Dom/Change/Listener", "WoltLabSuite/Core/Language"], function (require, exports, tslib_1, Ajax, DialogHandler, Listener_1, Language) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.init = void 0;
    Ajax = tslib_1.__importStar(Ajax);
    DialogHandler = tslib_1.__importStar(DialogHandler);
    Listener_1 = tslib_1.__importDefault(Listener_1);
    Language = tslib_1.__importStar(Language);
    class AcpUiBoardThreadFormOptionEdit {
        constructor() {
            this.knownElements = new WeakSet();
            this.optionId = undefined;
            this.rebuild();
            Listener_1.default.add("WoltLabSuite/Forum/Acp/Ui/Board/Thread/Form/Option/Edit", () => this.rebuild());
        }
        /**
         * Add eventListeners to the thread option edit forms.
         */
        rebuild() {
            document.querySelectorAll("#threadForm .jsEditButton").forEach((element) => {
                if (this.knownElements.has(element)) {
                    return;
                }
                element.addEventListener("click", (event) => this.loadDialog(event));
                this.knownElements.add(element);
            });
        }
        /**
         * Opens the edit dialog.
         */
        loadDialog(event) {
            event.preventDefault();
            const button = event.currentTarget;
            this.optionId = ~~button.dataset.objectId;
            Ajax.api(this, {
                actionName: "prepareEdit",
                objectIDs: [this.optionId],
            });
        }
        /**
         * Saves the dialog content for the option id.
         */
        saveDialog(dialogData) {
            Ajax.api(this, {
                actionName: "saveEdit",
                parameters: {
                    data: dialogData,
                },
                objectIDs: [this.optionId],
            });
        }
        _ajaxSuccess(data) {
            if (data.actionName === "saveEdit") {
                DialogHandler.closeDialog();
            }
            else if (data.actionName === "prepareEdit") {
                DialogHandler.loadDialog((data) => this.saveDialog(data), data.returnValues, Language.get("wbb.acp.board.threadForm.option.edit"));
            }
        }
        _ajaxSetup() {
            return {
                data: {
                    className: "wbb\\data\\thread\\form\\option\\ThreadFormOptionAction",
                },
            };
        }
    }
    let formOptionEdit;
    function init() {
        if (!formOptionEdit) {
            formOptionEdit = new AcpUiBoardThreadFormOptionEdit();
        }
    }
    exports.init = init;
});
