<?php

namespace wbb\data\thread;

use wcf\data\tag\Tag;
use wcf\system\tagging\TagEngine;

/**
 * Represents a list of tagged threads.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\Data\Thread
 */
class TaggedThreadList extends AccessibleThreadList
{
    /**
     * @var Tag[]
     */
    public $tags;

    /**
     * Creates a new TaggedThreadList object.
     *
     * @param Tag|Tag[] $tags
     */
    public function __construct($tags)
    {
        parent::__construct();

        $this->tags = ($tags instanceof Tag) ? [$tags] : $tags;

        $subselect = TagEngine::getInstance()->getSubselectForObjectsByTags(
            'com.woltlab.wbb.thread',
            $this->tags
        );
        $this->getConditionBuilder()->add(
            "thread.threadID IN ({$subselect['sql']})",
            $subselect['parameters']
        );
    }
}
