<?php

namespace wbb\system\cache\builder;

use wcf\system\cache\builder\AbstractCacheBuilder;
use wcf\system\WCF;

/**
 * Caches last posts and board clicks.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Cache\Builder
 */
class BoardDataCacheBuilder extends AbstractCacheBuilder
{
    /**
     * @inheritDoc
     */
    protected $maxLifetime = 300;

    /**
     * @inheritDoc
     */
    protected function rebuild(array $parameters)
    {
        $data = ['lastPostThreadIDs' => [], 'counts' => []];

        // counts
        $sql = "SELECT  boardID, clicks, threads, posts
                FROM    wbb" . WCF_N . "_board";
        $statement = WCF::getDB()->prepareStatement($sql);
        $statement->execute();
        while ($row = $statement->fetchArray()) {
            $data['counts'][$row['boardID']] = $row;
        }

        // last posts (ids)
        $sql = "SELECT  threadID
                FROM    wbb" . WCF_N . "_board_last_post";
        $statement = WCF::getDB()->prepareStatement($sql);
        $statement->execute();
        $data['lastPostThreadIDs'] = $statement->fetchAll(\PDO::FETCH_COLUMN);

        return $data;
    }
}
